/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.qwick;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.qwick.Qwick;
import uk.ac.bham.clg.cue.qwick.ToolBar;
import uk.ac.bham.clg.cue.qwick.ToolbarTarget;
import uk.ac.bham.clg.cue.utils.VectorSort;
import uk.ac.bham.clg.extawt.SwingWorker;

class CorpusPage
implements ToolbarTarget {
    static final boolean DEBUG = false;
    private JEditorPane infoBox = null;
    private JEditorPane totalInfoBox = null;
    private Hashtable corpusTable = null;
    private Hashtable corpusProps = null;
    private Hashtable corpusLabels = null;
    private final Vector corpusList = new Vector();
    private Cue cue;
    private Qwick qwick;
    private JFileChooser fileChooser = null;
    private String DEFAULTEXTENSION = ".cue";
    private JCheckBox[] corpusCheck = null;
    private int numSelectedCorpora = 0;
    private ToolBar toolbar = null;

    public CorpusPage(Qwick qwick, Cue cue, JPanel jPanel) {
        this.cue = cue;
        this.qwick = qwick;
        this.initVectors();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.corpusCheck = new JCheckBox[this.corpusList.size()];
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(100, 300));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", new JLabel(" "));
        jPanel3.add("East", new JLabel("    "));
        jPanel3.add("West", new JLabel("    "));
        jPanel3.add("South", new JLabel(" "));
        Box box = Box.createVerticalBox();
        int n = 0;
        while (n < this.corpusCheck.length) {
            this.corpusCheck[n] = new JCheckBox((String)this.corpusList.elementAt(n));
            box.add(this.corpusCheck[n]);
            this.corpusCheck[n].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = null;
                    ItemSelectable itemSelectable = itemEvent.getItemSelectable();
                    int n = 0;
                    while (n < CorpusPage.this.corpusCheck.length) {
                        if (CorpusPage.this.corpusCheck[n] == itemSelectable) {
                            string = (String)CorpusPage.this.corpusList.elementAt(n);
                            break;
                        }
                        ++n;
                    }
                    if (string != null) {
                        String string2 = (String)CorpusPage.this.corpusTable.get(string);
                        switch (itemEvent.getStateChange()) {
                            case 1: {
                                SwingWorker swingWorker = new SwingWorker(string2, CorpusPage.this){
                                    private final /* synthetic */ String val$name;
                                    private final /* synthetic */ CorpusPage this$0;
                                    {
                                        this.val$name = string;
                                        this.this$0 = corpusPage;
                                    }

                                    public Object construct() {
                                        CorpusPage.access$3(this.this$0).setActive(this.val$name, true);
                                        CorpusPage corpusPage = this.this$0;
                                        CorpusPage.access$5(corpusPage, CorpusPage.access$4(corpusPage) + 1);
                                        SwingUtilities.invokeLater(new Runnable(this.val$name, this.this$0){
                                            private final /* synthetic */ String val$name;
                                            private final /* synthetic */ CorpusPage this$0;
                                            {
                                                this.val$name = string;
                                                this.this$0 = corpusPage;
                                            }

                                            public void run() {
                                                CorpusPage.access$6(this.this$0).setEnabled(0, true);
                                                CorpusPage.access$7(this.this$0, this.val$name);
                                            }
                                        });
                                        return this;
                                    }
                                };
                                break;
                            }
                            case 2: {
                                CorpusPage.this.cue.setActive(string2, false);
                                CorpusPage corpusPage = CorpusPage.this;
                                corpusPage.numSelectedCorpora = corpusPage.numSelectedCorpora - 1;
                                if (CorpusPage.this.numSelectedCorpora == 0) {
                                    CorpusPage.this.toolbar.setEnabled(0, false);
                                }
                                CorpusPage.this.displayInfo(string2);
                                break;
                            }
                        }
                    }
                }
            });
            ++n;
        }
        jPanel3.add("Center", box);
        JScrollPane jScrollPane = new JScrollPane(jPanel3, 20, 30);
        jPanel2.add("Center", jScrollPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        this.infoBox = new JEditorPane();
        this.infoBox.setContentType("text/html");
        this.infoBox.setEditable(false);
        this.infoBox.setBackground(jPanel3.getBackground());
        this.infoBox.setPreferredSize(new Dimension(300, 150));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Corpus Description");
        this.infoBox.setBorder(titledBorder);
        jPanel4.add(this.infoBox);
        this.totalInfoBox = new JEditorPane();
        this.totalInfoBox.setContentType("text/html");
        this.totalInfoBox.setEditable(false);
        this.totalInfoBox.setBackground(jPanel3.getBackground());
        this.totalInfoBox.setPreferredSize(new Dimension(300, 150));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Working Corpus Information");
        this.totalInfoBox.setBorder(titledBorder2);
        jPanel4.add(this.totalInfoBox);
        jPanel2.add("East", jPanel4);
        jPanel.add("Center", jPanel2);
        try {
            this.totalInfoBox.setText("<blockquote><center>No corpora selected so far.</center></blockquote>");
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void displayInfo(int n) {
        this.displayInfo((String)this.corpusList.elementAt(n));
    }

    private void displayInfo(String string) {
        try {
            Corpus corpus = this.cue.getCorpus(string);
            if (corpus == null) {
                this.infoBox.setText("<blockquote>No Corpus selected</blockquote>");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<blockquote>");
                stringBuffer.append("Corpus <b>" + corpus.getLabel() + "</b><br>");
                stringBuffer.append("<i>" + corpus.getDesc() + "</i><br>");
                stringBuffer.append("Size: " + NumberFormat.getInstance().format(corpus.getSize()) + " words");
                stringBuffer.append("</blockquote>");
                this.infoBox.setText(stringBuffer.toString());
            }
            this.totalInfoBox.setText("<blockquote>Current total corpus size is <b>" + NumberFormat.getInstance().format(this.cue.getSize()) + "</b> words</blockquote>");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void help() {
        this.qwick.help("corpusPage.html");
    }

    public void init(ToolBar toolBar) {
        this.toolbar = toolBar;
        toolBar.noSort();
        toolBar.noPrint();
        toolBar.noSave();
    }

    private void initVectors() {
        this.corpusTable = new Hashtable();
        this.corpusProps = new Hashtable();
        this.corpusLabels = new Hashtable();
        String[] stringArray = this.cue.getAvailableCorpora();
        if (stringArray == null || stringArray.length == 0) {
            System.err.println("CorpusPage (init): no corpora available");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                Properties properties = this.cue.getCorpusProperties(string);
                if (properties != null) {
                    String string2 = properties.getProperty("label", string);
                    this.corpusList.addElement(string2);
                    this.corpusTable.put(string2, string);
                    this.corpusLabels.put(string, string2);
                    this.corpusProps.put(string2, properties);
                }
                ++n;
            }
            VectorSort.stringSort(this.corpusList);
        }
    }

    public void load() throws IOException {
        if (this.fileChooser == null) {
            this.fileChooser = this.qwick.getFileChooser();
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".cue");
            }

            public String getDescription() {
                return "Corpus Working Set";
            }
        };
        this.fileChooser.setFileFilter(fileFilter);
        int n = this.fileChooser.showOpenDialog(this.qwick);
        if (n == 0) {
            String[] stringArray = this.cue.getActiveCorporaNames();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.cue.setActive(stringArray[n2], false);
                    ++n2;
                }
            }
            String string = this.fileChooser.getSelectedFile().getName();
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            int n3 = dataInputStream.readInt();
            int n4 = 0;
            while (n4 < n3) {
                String string2 = dataInputStream.readUTF();
                this.cue.setActive(string2, true);
                ++n4;
            }
            dataInputStream.close();
            this.updateDisplay();
        }
    }

    public void print() {
    }

    public void save() throws IOException {
        int n = this.qwick.getSaveDialog().showDialog("Save Corpus Configuration", ".cue");
        if (n == 0) {
            int n2 = this.qwick.getSaveDialog().getFormat();
            Vector vector = this.cue.getActiveCorpora();
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.qwick.getSaveDialog().getFilename()));
            switch (n2) {
                case 0: {
                    dataOutputStream.writeBytes("<h1>Corpus Selection</h1>\n");
                    break;
                }
                case 1: {
                    dataOutputStream.writeBytes("Corpus Selection\n");
                    break;
                }
                case 2: {
                    dataOutputStream.writeInt(vector.size());
                    break;
                }
            }
            String string = null;
            int n3 = 0;
            while (n3 < vector.size()) {
                Corpus corpus = (Corpus)vector.elementAt(n3);
                Properties properties = this.cue.getCorpusProperties(corpus.getName());
                if (properties != null) {
                    string = properties.getProperty("label", corpus.getName());
                }
                if (string != null) {
                    string = corpus.getName();
                }
                switch (n2) {
                    case 0: {
                        dataOutputStream.writeBytes(String.valueOf(string) + "<br>\n");
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeBytes(String.valueOf(string) + "\n");
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeUTF(corpus.getName());
                        break;
                    }
                }
                ++n3;
            }
            dataOutputStream.close();
        }
    }

    public void sort() {
    }

    public void updateDisplay() {
        this.numSelectedCorpora = 0;
        try {
            int n = 0;
            while (n < this.corpusCheck.length) {
                String string = (String)this.corpusList.elementAt(n);
                String string2 = (String)this.corpusTable.get(string);
                if (string2 != null) {
                    this.corpusCheck[n].setSelected(this.cue.getActive(string2));
                    this.numSelectedCorpora += this.cue.getActive(string2) ? 1 : 0;
                } else {
                    System.err.println(String.valueOf(string) + ": cannot find name");
                }
                ++n;
            }
            this.toolbar.setEnabled(0, this.numSelectedCorpora != 0);
        }
        catch (NullPointerException nullPointerException) {}
    }
}

