/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.qwick;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.bham.clg.cue.corpus.Concordances;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.qwick.CollocationPage;
import uk.ac.bham.clg.cue.qwick.ConcordancePage;
import uk.ac.bham.clg.cue.qwick.CorpusPage;
import uk.ac.bham.clg.cue.qwick.LookAndFeel;
import uk.ac.bham.clg.cue.qwick.SaveDialog;
import uk.ac.bham.clg.cue.qwick.ToolBar;
import uk.ac.bham.clg.cue.qwick.ToolbarTarget;
import uk.ac.bham.clg.extawt.GUI;

public class Qwick
extends JFrame
implements ChangeListener {
    Box headBox = null;
    JTabbedPane tabPane = null;
    Cursor theNormalCursor;
    Cursor theWaitCursor;
    Toolkit theToolkit;
    Cue cue;
    Concordances concordances;
    Hashtable pageTable = null;
    JDialog helpDialog = null;
    JEditorPane htmlPane = null;
    JButton helpCancelButton = null;
    CorpusPage corpusPage = null;
    ConcordancePage concPage = null;
    CollocationPage collPage = null;
    ToolBar toolBar = null;
    JTabbedPane tabbedPane = null;
    SaveDialog fileChooser = new SaveDialog(this);
    JFileChooser fchooser = new JFileChooser();
    public KeyAdapter numberAdapter = null;

    public Qwick() {
        super("Qwick version 1.01 (1999)");
        Object object;
        this.theWaitCursor = new Cursor(3);
        this.waitCursor();
        this.theNormalCursor = new Cursor(1);
        LookAndFeel.setup();
        try {
            object = new PrintStream(new FileOutputStream("qwick.log"));
            System.setErr((PrintStream)object);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        this.numberAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (!Character.isDigit(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }
        };
        try {
            this.cue = new Cue();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Qwick: " + fileNotFoundException);
            System.exit(1);
        }
        this.pageTable = new Hashtable();
        this.helpDialog = new JDialog(this, "Online Help", true);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setPreferredSize(new Dimension(400, 350));
        object = new JScrollPane(this.htmlPane);
        ((JComponent)object).setPreferredSize(new Dimension(400, 350));
        this.helpDialog.getContentPane().add("Center", (Component)object);
        this.helpCancelButton = new JButton("Close Help Window");
        this.helpCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)Qwick.this.helpDialog).setVisible(false);
            }
        });
        this.helpDialog.getContentPane().add("South", this.helpCancelButton);
        this.helpDialog.pack();
        this.concordances = null;
        this.initialise();
        this.show();
        this.resetCursor();
        String string = this.cue.getHomeDir();
        File file = new File(String.valueOf(string) + File.separatorChar + "MyFiles");
        this.fchooser.setCurrentDirectory(file);
        this.fileChooser.setDir(string);
    }

    void exit() {
        int n = JOptionPane.showConfirmDialog(this, "Do you really want to exit QWICK?", "Please Confirm", 0);
        if (n == 0) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    public Cue getApplication() {
        return this.cue;
    }

    Object getCurrentPage() {
        return this.pageTable.get(this.tabbedPane.getSelectedComponent());
    }

    public JFileChooser getFileChooser() {
        return this.fchooser;
    }

    public SaveDialog getSaveDialog() {
        return this.fileChooser;
    }

    public ToolBar getToolbar() {
        return this.toolBar;
    }

    public Concordances getWorkingSet() {
        return this.concordances;
    }

    public void help(String string) {
        String string2 = "file:" + this.cue.getHomeDir() + File.separatorChar + "qwick-1.0" + File.separatorChar + "help" + File.separatorChar + string;
        try {
            URL uRL = new URL(string2);
            this.htmlPane.setPage(uRL);
            this.resetCursor();
            if (!this.helpDialog.isShowing()) {
                ((Component)this.helpDialog).setBounds(GUI.centerWindow(this.helpDialog.getSize()));
                this.helpDialog.show();
            }
        }
        catch (Exception exception) {
            this.resetCursor();
            JOptionPane.showMessageDialog(this, "Help System: " + exception, "Help Error", 0);
        }
    }

    public void initialise() {
        Container container;
        this.headBox = Box.createVerticalBox();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JPanel jPanel = new JPanel();
        this.toolBar = new ToolBar(this);
        String string = String.valueOf(this.cue.getLibDir()) + File.separatorChar + "images" + File.separatorChar;
        JButton jButton = new JButton(new ImageIcon(String.valueOf(string) + "open.gif"));
        jButton.addActionListener(this.toolBar);
        jButton.setToolTipText("Load");
        jToolBar.add(jButton);
        this.toolBar.add(jButton, 1);
        JButton jButton2 = new JButton(new ImageIcon(String.valueOf(string) + "save.gif"));
        jButton2.addActionListener(this.toolBar);
        jButton2.setToolTipText("Save");
        jToolBar.add(jButton2);
        this.toolBar.add(jButton2, 0);
        JButton jButton3 = new JButton(new ImageIcon(String.valueOf(string) + "print.gif"));
        jButton3.addActionListener(this.toolBar);
        jButton3.setToolTipText("Print");
        jToolBar.add(jButton3);
        this.toolBar.add(jButton3, 3);
        JButton jButton4 = new JButton(new ImageIcon(String.valueOf(string) + "tilecascade.gif"));
        jButton4.setToolTipText("Sort");
        jToolBar.add(jButton4);
        this.toolBar.add(jButton4, 2);
        jButton4.addActionListener(this.toolBar);
        JButton jButton5 = new JButton(new ImageIcon(String.valueOf(string) + "help.gif"));
        jButton5.addActionListener(this.toolBar);
        jButton5.setToolTipText("Help");
        jToolBar.add(jButton5);
        this.toolBar.add(jButton5, 5);
        JButton jButton6 = new JButton(new ImageIcon(String.valueOf(string) + "exit.gif"));
        jButton6.addActionListener(this.toolBar);
        jButton6.setToolTipText("Exit");
        jToolBar.add(jButton6);
        this.toolBar.add(jButton6, 4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("East", jToolBar);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        JLabel jLabel = new JLabel("QWICK");
        jLabel.setFont(new Font("times", 0, 20));
        jLabel.setForeground(Color.blue);
        jPanel3.add(jLabel);
        jPanel2.add("Center", jPanel3);
        this.headBox.add(jPanel2);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(this);
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        try {
            container = new JPanel();
            this.corpusPage = new CorpusPage(this, this.cue, (JPanel)container);
            this.pageTable.put(container, this.corpusPage);
            this.tabbedPane.addTab("Corpus", null, container, "Select a Set of Corpora");
            container = new JPanel();
            this.concPage = new ConcordancePage(this, this.cue, (JPanel)container);
            this.pageTable.put(container, this.concPage);
            this.tabbedPane.addTab("Concordance", null, container, "Retrieve Concordance Lines");
            container = new JPanel();
            this.collPage = new CollocationPage(this, this.cue, (JPanel)container);
            this.pageTable.put(container, this.collPage);
            this.tabbedPane.addTab("Collocation", null, container, "Compute Collocations");
        }
        catch (NullPointerException nullPointerException) {}
        this.headBox.add(this.tabbedPane);
        jPanel.add(this.headBox);
        this.getContentPane().add(jPanel);
        this.pack();
        ((Component)this).setBounds(GUI.centerWindow(this.getSize()));
        this.show();
        try {
            this.corpusPage.init(this.toolBar);
        }
        catch (NullPointerException nullPointerException) {}
        this.setDefaultCloseOperation(0);
        container = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Qwick.this.dispose();
                System.exit(0);
            }

            public void windowClosing(WindowEvent windowEvent) {
                Qwick.this.exit();
            }
        });
    }

    public static void main(String[] stringArray) {
        try {
            Qwick qwick = new Qwick();
            if (qwick == null) {
                System.err.println("Qwick failed!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    void resetCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)Qwick.this).setCursor(Qwick.this.theNormalCursor);
                if (Qwick.this.tabbedPane != null) {
                    int n = 0;
                    while (n < 3) {
                        Qwick.this.tabbedPane.setEnabledAt(n, true);
                        ++n;
                    }
                }
            }
        });
    }

    public void select(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public void setWorkingSet(Concordances concordances) {
        this.concordances = concordances;
        this.collPage.invalidateData();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.toolBar.reset();
            ToolbarTarget toolbarTarget = (ToolbarTarget)this.getCurrentPage();
            if (this.getCurrentPage() == this.corpusPage) {
                this.corpusPage.updateDisplay();
            }
            if (toolbarTarget != null) {
                toolbarTarget.init(this.toolBar);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    void waitCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)Qwick.this).setCursor(Qwick.this.theWaitCursor);
                if (Qwick.this.tabbedPane != null) {
                    int n = 0;
                    while (n < 3) {
                        Qwick.this.tabbedPane.setEnabledAt(n, false);
                        ++n;
                    }
                }
            }
        });
    }
}

