/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.qwick;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class SaveDialog {
    private JPanel accessory = null;
    private JRadioButton htmlFormat = null;
    private JRadioButton plainFormat = null;
    private JRadioButton binaryFormat = null;
    private JEditorPane infoBox = null;
    private JFrame parent = null;
    private JFileChooser filechooser = null;
    public static final int HTML = 0;
    public static final int PLAIN = 1;
    public static final int BINARY = 2;
    private static final String htmlString = "Files saved in HTML can be viewed in a web browser, or put directly onto the web.  You can <i>not</i> reload those files into QWICK.";
    private static final String plainString = "Files saved in plain text format can easily be loaded into word processing documents.  You can <i>not</i> reload those files into QWICK.";
    private static final String binaryString = "Files saved in machine-readable form can be reloaded into Qwick. Choose this format if you want to save your work and return to it at a later stage.";
    private int status = 0;
    private int format = 0;
    private String extension = ".html";
    private String binaryExtension = ".cue";

    public SaveDialog(JFrame jFrame) {
        this.parent = jFrame;
        this.accessory = new JPanel();
        this.accessory.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Format");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridLayout(3, 1));
        this.infoBox = new JEditorPane();
        this.infoBox.setContentType("text/html");
        this.infoBox.setEditable(false);
        this.infoBox.setText(htmlString);
        this.infoBox.setPreferredSize(new Dimension(300, 150));
        this.infoBox.setMinimumSize(new Dimension(300, 150));
        this.infoBox.setMaximumSize(new Dimension(300, 150));
        this.infoBox.setBackground(jPanel.getBackground());
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Description");
        this.infoBox.setBorder(titledBorder2);
        final FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".html") || file.getName().endsWith(".htm") || file.isDirectory();
            }

            public String getDescription() {
                return "HTML Files";
            }
        };
        this.htmlFormat = new JRadioButton("HTML");
        this.htmlFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                infoBox.setText(SaveDialog.htmlString);
                format = 0;
                extension = ".html";
                filechooser.setFileFilter(fileFilter);
                filechooser.rescanCurrentDirectory();
            }
        });
        this.htmlFormat.setSelected(true);
        this.plainFormat = new JRadioButton("Plain Text");
        this.plainFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveDialog.this.infoBox.setText(SaveDialog.plainString);
                SaveDialog.this.format = 1;
                SaveDialog.this.extension = ".txt";
                SaveDialog.this.filechooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.getName().endsWith(".txt") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "Plain Text Files";
                    }
                });
                SaveDialog.this.filechooser.rescanCurrentDirectory();
            }
        });
        this.binaryFormat = new JRadioButton("Machine-Readable");
        this.binaryFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveDialog.this.infoBox.setText(SaveDialog.binaryString);
                SaveDialog.this.format = 2;
                SaveDialog.this.extension = SaveDialog.this.binaryExtension;
                SaveDialog.this.filechooser.setFileFilter(new FileFilter(SaveDialog.this){
                    private final /* synthetic */ SaveDialog this$0;
                    {
                        this.this$0 = saveDialog;
                    }

                    public boolean accept(File file) {
                        return file.getName().endsWith(SaveDialog.access$6(this.this$0)) || file.isDirectory();
                    }

                    public String getDescription() {
                        return "Qwick Corpus Files";
                    }
                });
                SaveDialog.this.filechooser.rescanCurrentDirectory();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.htmlFormat);
        buttonGroup.add(this.plainFormat);
        buttonGroup.add(this.binaryFormat);
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.add(this.htmlFormat);
        jPanel.add(this.plainFormat);
        jPanel.add(this.binaryFormat);
        this.accessory.add("North", jPanel);
        this.accessory.add("Center", this.infoBox);
        this.filechooser = new JFileChooser();
        this.filechooser.setAccessory(this.accessory);
        this.filechooser.setPreferredSize(new Dimension(500, 400));
    }

    static /* synthetic */ int access$1(SaveDialog saveDialog) {
        return saveDialog.format;
    }

    static /* synthetic */ String access$3(SaveDialog saveDialog) {
        return saveDialog.extension;
    }

    public String getFilename() {
        if (this.status == 1) {
            return null;
        }
        File file = this.filechooser.getSelectedFile();
        String string = file.getName();
        if (!string.endsWith(this.extension)) {
            string = String.valueOf(string) + this.extension;
        }
        return string;
    }

    public int getFormat() {
        return this.format;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        SaveDialog saveDialog = new SaveDialog(jFrame);
    }

    public void setBinary(boolean bl) {
        this.binaryFormat.setEnabled(bl);
    }

    public void setDir(String string) {
        File file = new File(string);
        this.filechooser.setCurrentDirectory(file);
    }

    public int showDialog(String string, String string2) {
        int n;
        File file;
        this.binaryExtension = string2;
        this.filechooser.rescanCurrentDirectory();
        this.status = this.filechooser.showDialog(this.parent, string);
        if (this.status == 0 && (file = this.filechooser.getSelectedFile()).exists() && (n = JOptionPane.showConfirmDialog(this.parent, "The file exists.  Do you want to overwrite it?", "Please Confirm", 0)) != 0) {
            this.status = 1;
        }
        return this.status;
    }
}

