/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.qwick;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import uk.ac.bham.clg.cue.qwick.Qwick;
import uk.ac.bham.clg.cue.qwick.ToolbarTarget;

class ToolBar
implements ActionListener {
    Qwick parent = null;
    Hashtable codeTable = null;
    public static final int SAVE = 0;
    public static final int LOAD = 1;
    public static final int SORT = 2;
    public static final int PRINT = 3;
    public static final int EXIT = 4;
    public static final int HELP = 5;

    public ToolBar(Qwick qwick) {
        this.parent = qwick;
        this.codeTable = new Hashtable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Integer n = (Integer)this.codeTable.get(actionEvent.getSource());
        ToolbarTarget toolbarTarget = (ToolbarTarget)this.parent.getCurrentPage();
        if (n != null) {
            switch (n) {
                case 0: {
                    try {
                        toolbarTarget.save();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this.parent, "Error: " + iOException, "Save Error", 0);
                    }
                    break;
                }
                case 1: {
                    try {
                        toolbarTarget.load();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this.parent, "Error: " + iOException, "Load Error", 0);
                    }
                    break;
                }
                case 2: {
                    toolbarTarget.sort();
                    break;
                }
                case 3: {
                    toolbarTarget.print();
                    break;
                }
                case 4: {
                    this.parent.exit();
                    break;
                }
                case 5: {
                    toolbarTarget.help();
                    break;
                }
                default: {
                    System.err.println("unknown toolbar opcode " + n);
                    break;
                }
            }
        }
    }

    public void add(JButton jButton, int n) {
        this.codeTable.put(jButton, new Integer(n));
    }

    public void noExit() {
        this.setEnabled(4, false);
    }

    public void noHelp() {
        this.setEnabled(5, false);
    }

    public void noLoad() {
        this.setEnabled(1, false);
    }

    public void noPrint() {
        this.setEnabled(3, false);
    }

    public void noSave() {
        this.setEnabled(0, false);
    }

    public void noSort() {
        this.setEnabled(2, false);
    }

    public void reset() {
        Enumeration enumeration = this.codeTable.keys();
        while (enumeration.hasMoreElements()) {
            JButton jButton = (JButton)enumeration.nextElement();
            jButton.setEnabled(true);
        }
    }

    public void setEnabled(int n, boolean bl) {
        Enumeration enumeration = this.codeTable.keys();
        while (enumeration.hasMoreElements()) {
            JButton jButton = (JButton)enumeration.nextElement();
            Integer n2 = (Integer)this.codeTable.get(jButton);
            if (n2 != n) continue;
            jButton.setEnabled(bl);
        }
    }
}

