/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.extawt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;
import uk.ac.bham.clg.cue.corpus.ConcordanceLine;
import uk.ac.bham.clg.extawt.ConcordanceModel;
import uk.ac.bham.clg.extawt.Unicode;

public class ConcordanceList
extends JComponent
implements MouseListener,
ComponentListener,
ItemSelectable {
    private String[] left = null;
    private String[] node = null;
    private String[] right = null;
    private boolean[] isSelected = null;
    private int numLines = 0;
    private int lineHeight;
    private Font theFont = null;
    private Color textColor = Color.black;
    private Color nodeColor = Color.red;
    private Color backColor = Color.white;
    private Color selectedColor = Color.yellow;
    private FontMetrics theFontMetrics = null;
    private int vMargin = 0;
    private int hMargin = 0;
    private int fontSize = 16;
    private boolean frozen = false;
    private int currentTop = 0;
    private Vector listeners = null;
    private int id = 0;
    private ConcordanceModel model = null;
    private boolean printNumbers = true;
    public static final boolean DEBUG = false;

    public ConcordanceList(ConcordanceModel concordanceModel) {
        this.model = concordanceModel;
        this.setFont(new Font("times", 0, this.fontSize));
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        ConcordanceList.this.lineUp();
                        break;
                    }
                    case 33: {
                        ConcordanceList.this.pageUp();
                        break;
                    }
                    case 40: {
                        ConcordanceList.this.lineDown();
                        break;
                    }
                    case 34: {
                        ConcordanceList.this.pageDown();
                        break;
                    }
                }
            }
        });
        this.setOpaque(true);
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(itemListener);
    }

    public void addNotify() {
        super.addNotify();
        this.numLines = this.getRows();
        this.left = new String[this.numLines];
        this.node = new String[this.numLines];
        this.right = new String[this.numLines];
        this.isSelected = new boolean[this.numLines];
    }

    public void clear() {
        boolean bl = this.frozen;
        this.frozen = true;
        int n = 0;
        while (n < this.numLines) {
            this.clearLine(n);
            ++n;
        }
        this.frozen = bl;
        this.paint(this.getGraphics());
    }

    public void clearLine(int n) {
        this.setLine(n, "", "", "", false);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.setFrozen(true);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = this.numLines;
        this.numLines = this.getRows();
        if (this.numLines < 0) {
            return;
        }
        if (n != this.numLines) {
            String[] stringArray = new String[this.numLines];
            int n2 = 0;
            while (n2 < this.left.length) {
                stringArray[n2] = this.left[n2];
                ++n2;
            }
            this.left = stringArray;
            stringArray = new String[this.numLines];
            int n3 = 0;
            while (n3 < this.node.length) {
                stringArray[n3] = this.node[n3];
                ++n3;
            }
            this.node = stringArray;
            stringArray = new String[this.numLines];
            int n4 = 0;
            while (n4 < this.right.length) {
                stringArray[n4] = this.right[n4];
                ++n4;
            }
            this.right = stringArray;
            boolean[] blArray = new boolean[this.numLines];
            int n5 = 0;
            while (n5 < this.isSelected.length) {
                blArray[n5] = this.isSelected[n5];
                ++n5;
            }
            this.isSelected = blArray;
        }
        this.display(this.currentTop);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.setFrozen(false);
    }

    public void delItem(int n) {
        if ((n -= this.currentTop) >= 0 && n < this.numLines) {
            boolean bl = this.frozen;
            this.frozen = true;
            int n2 = n;
            while (n2 < this.numLines - 2) {
                this.moveLine(n2 + 1, n2);
                ++n2;
            }
            this.displayLine(this.numLines - 1);
            this.frozen = false;
            this.paint(this.getGraphics());
            this.frozen = bl;
        }
    }

    public void display(int n) {
        this.currentTop = n;
        int n2 = 0;
        while (n2 < this.numLines) {
            this.displayLine(n2);
            ++n2;
        }
    }

    private void displayLine(int n) {
        ConcordanceLine concordanceLine = this.model.getLine(this.currentTop + n);
        if (concordanceLine == null) {
            this.clearLine(n);
        } else {
            boolean bl = this.model.isSelected(this.currentTop + n);
            this.setLine(n, concordanceLine.getLeftContext(), concordanceLine.getNodeWord(), concordanceLine.getRightContext(), bl);
        }
    }

    private void drawLine(Graphics graphics, int n, int n2) {
        Font font = this.theFont;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = (int)(1.01 * (double)fontMetrics.getMaxAscent() + (double)fontMetrics.getMaxDescent());
        this.hMargin = fontMetrics.charWidth(' ');
        Dimension dimension = this.getSize();
        int n4 = dimension.width / 2;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n5 = this.vMargin + (n + 1) * n3;
        boolean bl = this.isSelected[n];
        string2 = this.node[n];
        string = this.left[n];
        string3 = this.right[n];
        if (bl) {
            graphics.setColor(this.selectedColor);
        } else {
            graphics.setColor(this.backColor);
        }
        graphics.fillRect(0, n5 - n3, n4 * 2, n3);
        if (string2 != null && !"".equals(string2)) {
            int n6 = n5 - fontMetrics.getMaxDescent();
            int n7 = n4 - this.hMargin - fontMetrics.stringWidth(string2) / 2;
            int n8 = n7 - fontMetrics.stringWidth(string) - this.hMargin;
            int n9 = n7 + fontMetrics.stringWidth(string2) + this.hMargin;
            graphics.setColor(this.textColor);
            graphics.drawString(string, n8, n6);
            if (this.printNumbers) {
                if (bl) {
                    graphics.setColor(this.selectedColor);
                } else {
                    graphics.setColor(this.backColor);
                }
                String string4 = " " + (this.currentTop + this.numLines) + "   ";
                graphics.fillRect(0, n5 - n3, fontMetrics.stringWidth(string4), n3);
                graphics.setColor(Color.blue);
                String string5 = " " + (n + this.currentTop + 1) + "   ";
                graphics.drawString(string5, fontMetrics.stringWidth(string4) - fontMetrics.stringWidth(string5), n6);
                graphics.setColor(this.textColor);
            }
            graphics.drawString(string3, n9, n6);
            graphics.setColor(this.nodeColor);
            graphics.drawString(string2, n7, n6);
        }
    }

    public Font getFont() {
        return this.theFont;
    }

    public int getItemCount() {
        int n = 0;
        while (n < this.numLines) {
            if (this.node[n] == null || this.node[n].equals("")) break;
            ++n;
        }
        return n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(500, 400);
        return dimension;
    }

    public int getRows() {
        Dimension dimension = this.getSize();
        return dimension.height / this.lineHeight + 1;
    }

    public Vector getSelected() {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.node.length) {
            if (this.isSelected[n]) {
                vector.addElement(new Integer(this.currentTop + n));
            }
            ++n;
        }
        return vector;
    }

    public int[] getSelectedIndexes() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.node.length) {
            if (this.isSelected[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n != 0) {
            int[] nArray = new int[n];
            n = 0;
            int n3 = 0;
            while (n3 < this.node.length) {
                if (this.isSelected[n3]) {
                    nArray[n++] = n3;
                }
                ++n3;
            }
            return nArray;
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        Vector vector = this.getSelected();
        Object[] objectArray = new Integer[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void lineDown() {
        if (this.currentTop < this.model.getSize()) {
            ++this.currentTop;
            int n = 1;
            while (n < this.numLines) {
                this.moveLine(n, n - 1);
                ++n;
            }
            this.displayLine(this.getRows() - 1);
        }
    }

    public void lineUp() {
        if (this.currentTop > 0) {
            --this.currentTop;
            int n = this.getRows() - 2;
            while (n >= 0) {
                this.moveLine(n, n + 1);
                --n;
            }
            this.displayLine(0);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getY() / this.lineHeight;
        if (n <= this.getRows() && n + this.currentTop < this.model.getSize()) {
            if (this.isSelected[n]) {
                this.isSelected[n] = false;
                this.model.unsetSelected(n + this.currentTop);
            } else {
                if ((mouseEvent.getModifiers() & 1) == 0) {
                    int n2 = 0;
                    while (n2 < this.getRows()) {
                        if (this.isSelected[n2]) {
                            this.isSelected[n2] = false;
                            this.drawLine(this.getGraphics(), n2, this.currentTop);
                            if (this.listeners != null) {
                                ItemEvent itemEvent = new ItemEvent(this, this.id++, new Integer(n2), 2);
                                int n3 = 0;
                                while (n3 < this.listeners.size()) {
                                    ((ItemListener)this.listeners.elementAt(n3)).itemStateChanged(itemEvent);
                                    ++n3;
                                }
                            }
                        }
                        ++n2;
                    }
                    this.model.clearSelection();
                }
                this.isSelected[n] = true;
                this.model.setSelected(n + this.currentTop);
            }
            this.drawLine(this.getGraphics(), n, this.currentTop);
            if (this.listeners != null) {
                ItemEvent itemEvent = new ItemEvent(this, this.id++, new Integer(n), this.isSelected[n] ? 1 : 2);
                int n4 = 0;
                while (n4 < this.listeners.size()) {
                    ItemListener itemListener = (ItemListener)this.listeners.elementAt(n4);
                    itemListener.itemStateChanged(itemEvent);
                    ++n4;
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void moveLine(int n, int n2) {
        String string = this.left[n];
        String string2 = this.node[n];
        String string3 = this.right[n];
        boolean bl = this.isSelected[n];
        this.setLine(n2, string, string2, string3, bl);
    }

    public void pageDown() {
        this.currentTop += this.getRows() - 1;
        if (this.currentTop > this.model.getSize()) {
            this.currentTop = this.model.getSize() - this.getRows() - 1;
        }
        if (this.currentTop < 0) {
            this.currentTop = 0;
        }
        this.display(this.currentTop);
    }

    public void pageUp() {
        if (this.currentTop > 0) {
            this.currentTop -= this.getRows() - 1;
            if (this.currentTop < 0) {
                this.currentTop = 0;
            }
            this.display(this.currentTop);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.frozen) {
            int n = 0;
            while (n < this.numLines) {
                this.drawLine(graphics, n, this.currentTop);
                ++n;
            }
        } else {
            System.err.println("trying to paint frozen list");
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(itemListener);
    }

    public void setFont(Font font) {
        this.theFont = font;
        this.theFontMetrics = ((Component)this).getFontMetrics(font);
        int n = this.theFontMetrics.getMaxAscent();
        int n2 = this.theFontMetrics.getMaxDescent();
        this.lineHeight = n + n2;
        this.hMargin = this.theFontMetrics.charWidth(' ');
    }

    public void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    public void setLine(int n, String string, String string2, String string3, boolean bl) {
        if (n < 0 || n >= this.numLines) {
            System.err.println("out of bounds: " + n);
            return;
        }
        this.left[n] = Unicode.replace(string);
        this.node[n] = Unicode.replace(string2);
        this.right[n] = Unicode.replace(string3);
        this.isSelected[n] = bl;
        if (!this.frozen) {
            this.drawLine(this.getGraphics(), n, this.currentTop);
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        System.err.println("setSize: " + n + "," + n2);
    }
}

