/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.extawt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;
import uk.ac.bham.clg.extawt.PropertyPagePanel;
import uk.ac.bham.clg.util.Global;

class PropertyTabCanvas
extends Canvas {
    private static final int GAP = 8;
    protected PropertyPagePanel body;
    Vector tabName;
    Vector tabWidth;
    protected int maxWidth;
    protected int maxHeight;
    int texty;
    Color high;
    Color bgnd;
    Color low;
    int currentTab;
    Font tabFont;
    int where;
    Rectangle clipRect;

    public PropertyTabCanvas(int n, PropertyPagePanel propertyPagePanel, Color color, Color color2, Color color3) {
        this.where = n;
        this.body = propertyPagePanel;
        this.high = color;
        this.bgnd = color2;
        this.low = color3;
        this.tabName = new Vector();
        this.tabWidth = new Vector();
        this.currentTab = 0;
        this.maxWidth = 0;
        String string = Global.getBestFont("Helvetic");
        this.tabFont = new Font(string, 0, 14);
        FontMetrics fontMetrics = this.getFontMetrics(this.tabFont);
        this.maxHeight = fontMetrics.getHeight() * 3 / 2;
        this.texty = (this.maxHeight - fontMetrics.getHeight()) / 2;
        this.texty += fontMetrics.getAscent();
    }

    public synchronized void addPage(String string) {
        this.tabName.addElement(string);
        FontMetrics fontMetrics = this.getFontMetrics(this.tabFont);
        int n = 16 + fontMetrics.stringWidth(string);
        Integer n2 = new Integer(n);
        this.tabWidth.addElement(n2);
        this.maxWidth += n;
    }

    public void doPaint(Graphics graphics) {
        if (this.tabName.size() == 0) {
            return;
        }
        Dimension dimension = this.size();
        int n = 0;
        int n2 = 0;
        Image image = this.createImage(dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setFont(this.tabFont);
        graphics2.setColor(this.bgnd);
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        int n3 = 0;
        while (n3 < this.tabWidth.size()) {
            int n4;
            int n5;
            int n6;
            n = (Integer)this.tabWidth.elementAt(n3);
            if (n3 != this.currentTab) {
                if (this.where == 0) {
                    n6 = 2;
                    n5 = dimension.height;
                } else {
                    n6 = 0;
                    n5 = dimension.height - 2;
                }
            } else {
                n6 = 0;
                n5 = dimension.height;
            }
            graphics2.setColor(this.low);
            String string = (String)this.tabName.elementAt(n3);
            graphics2.drawString(string, n2 + 8, this.texty);
            if (this.where == 1) {
                graphics2.drawLine(n2 + 2, n5 - 1, n2 + n - 3, n5 - 1);
                graphics2.drawLine(n2 + 1, n5 - 2, n2 + n - 2, n5 - 2);
                graphics2.drawLine(n2 + n - 2, n6, n2 + n - 2, n5 - 2);
                graphics2.drawLine(n2 + n - 1, n6, n2 + n - 1, n5 - 3);
            } else {
                graphics2.drawLine(n2 + n - 2, n6 + 1, n2 + n - 2, n5 - 1);
                graphics2.drawLine(n2 + n - 1, n6 + 2, n2 + n - 1, n5 - 1);
            }
            graphics2.setColor(this.high);
            if (this.where == 1) {
                graphics2.drawLine(n2, n6, n2, n5 - 3);
                graphics2.drawLine(n2 + 1, n6, n2 + 1, n5 - 2);
            } else {
                graphics2.drawLine(n2, n6 + 2, n2, n5 - 1);
                graphics2.drawLine(n2 + 1, n6 + 1, n2 + 1, n5 - 1);
                graphics2.drawLine(n2 + 2, n6, n2 + n - 3, n6);
                graphics2.drawLine(n2 + 1, n6 + 1, n2 + n - 2, n6 + 1);
            }
            if (n3 == this.currentTab) {
                graphics2.setColor(this.bgnd);
                n4 = 2;
            } else {
                if (this.where == 0) {
                    graphics2.setColor(this.high);
                } else {
                    graphics2.setColor(this.low);
                }
                n4 = 0;
            }
            if (this.where == 0) {
                graphics2.drawLine(n2 + n4, n5 - 1, n2 + n - n4 - 1, n5 - 1);
                graphics2.drawLine(n2 + n4, n5 - 2, n2 + n - n4 - 1, n5 - 2);
            } else {
                graphics2.drawLine(n2 + n4, 0, n2 + n - n4 - 1, 0);
                graphics2.drawLine(n2 + n4, 1, n2 + n - n4 - 1, 1);
            }
            n2 += n;
            ++n3;
        }
        n = this.size().width;
        if (n >= n2) {
            if (this.where == 0) {
                graphics2.setColor(this.high);
                graphics2.drawLine(n2 - 2, dimension.height - 1, n - 1, dimension.height - 1);
                graphics2.drawLine(n2 - 1, dimension.height - 2, n - 1, dimension.height - 2);
                graphics2.setColor(this.low);
                graphics2.drawLine(n - 2, dimension.height - 1, n - 1, dimension.height - 1);
                graphics2.drawLine(n - 1, dimension.height - 2, n - 1, dimension.height - 2);
            } else {
                graphics2.setColor(this.low);
                graphics2.drawLine(n2 - 2, 0, n - 1, 0);
                graphics2.drawLine(n2 - 1, 1, n - 1, 1);
            }
        }
        graphics.drawImage(image, 0, 0, this);
        image.flush();
        graphics2.dispose();
    }

    public Dimension minimumSize() {
        int n = this.body.minimumSize().width;
        n = Math.max(this.maxWidth, n);
        return new Dimension(n, this.maxHeight);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.tabName.size() == 0 || n >= this.maxWidth) {
            return true;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.tabWidth.size()) {
            int n6 = (Integer)this.tabWidth.elementAt(n5);
            if (n >= n4 && n < n4 + n6) break;
            ++n3;
            n4 += n6;
            ++n5;
        }
        if (n3 < this.tabWidth.size()) {
            this.showPage((String)this.tabName.elementAt(n3));
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.clipRect != null) {
            graphics.dispose();
            graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.clipRect(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        }
        this.doPaint(graphics);
        this.clipRect = null;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = this.size();
        if (dimension.width != n3 || dimension.height != n4) {
            this.clipRect = new Rectangle(0, 0, n3, n4);
        }
        super.reshape(n, n2, n3, n4);
    }

    public synchronized void showPage(String string) {
        int n = this.tabName.indexOf(string);
        if (n >= 0 && n != this.currentTab) {
            this.currentTab = n;
            this.repaint();
            this.body.showPage(string);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

