/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import java.util.Properties;

public class ISO2UTF {
    private Properties conversionTable = new Properties();
    private static ISO2UTF instance = null;

    private ISO2UTF() throws IOException {
        try {
            Properties properties = System.getProperties();
            String string = String.valueOf(properties.getProperty("cue.home", ".")) + File.separator + "lib" + File.separator + "entities.iso";
            File file = new File(string);
            if (!(file.exists() || file.isFile() || file.canRead())) {
                throw new FileNotFoundException(string);
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            this.conversionTable.load(fileInputStream);
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        System.err.println("ISO2UTF: loaded " + ((Hashtable)this.conversionTable).size() + " entities");
    }

    public final void convertStreams(InputStream inputStream, OutputStream outputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        try {
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                string = this.convertString(string);
                ISO2UTF.writeUTF(outputStream, string);
            } while (string != null);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public final String convertString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) != '&') {
                stringBuffer.append(c);
                continue;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (n < string.length()) {
                c = string.charAt(n++);
                while (!Character.isWhitespace(c) && c != ';' && n < string.length()) {
                    stringBuffer2.append(c);
                    c = string.charAt(n++);
                }
            } else {
                System.err.println("premature EOL: " + string);
            }
            stringBuffer.append(this.lookup(stringBuffer2.toString()));
            if (!Character.isWhitespace(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static ISO2UTF getInstance() throws IOException {
        if (instance == null) {
            instance = new ISO2UTF();
        }
        return instance;
    }

    public char lookup(String string) {
        String string2 = this.conversionTable.getProperty(string, "0000");
        if (string2.equals("0000")) {
            System.err.println("unknown entity '" + string + "'");
            ((Hashtable)this.conversionTable).put(string, "'?'");
            return '?';
        }
        if (string2.startsWith("'") && string2.length() > 1) {
            return string2.charAt(1);
        }
        int n = Integer.parseInt(string2, 16);
        return (char)n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("usage: ISO2UTF <inputfile> <outputfile>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("Cannot find file `" + string + "'");
            System.exit(1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ISO2UTF iSO2UTF = new ISO2UTF();
            iSO2UTF.convertStreams(fileInputStream, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
    }

    public static String readUTF(InputStream inputStream) throws IOException, UTFDataFormatException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(80);
        block5: while ((n = inputStream.read()) >= 0) {
            if (n == 10 || n == 13) {
                if (stringBuffer.length() != 0) break;
                continue;
            }
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    stringBuffer.append((char)n);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int n2 = inputStream.read();
                    if (n2 < 0 || (n2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("premature end of data");
                    }
                    stringBuffer.append((char)((n & 0x1F) << 6 | n2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    int n2 = inputStream.read();
                    int n3 = inputStream.read();
                    if (n2 < 0 || n3 < 0 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("premature end of data");
                    }
                    stringBuffer.append((char)((n & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F));
                    continue block5;
                }
            }
            throw new UTFDataFormatException("Unexpected " + n);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static final void writeUTF(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
            } else if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c & 0x3F);
            } else {
                outputStream.write(0xC0 | c >> 6 & 0x1F);
                outputStream.write(0x80 | c & 0x3F);
            }
            ++n2;
        }
    }

    public static final void writelnUTF(OutputStream outputStream, String string) throws IOException {
        ISO2UTF.writeUTF(outputStream, string);
        outputStream.write(10);
    }
}

