/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util.options;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import uk.ac.bham.clg.util.parser.OptionParser;
import uk.ac.bham.clg.util.parser.ParseError;
import uk.ac.bham.clg.util.parser.ParseNode;

public class ValueModel {
    String name = null;
    String label = null;
    String type = null;
    Class typeAsClass = null;
    Object[] values = null;
    String[] names = null;
    Object theValue = null;
    int defaultSelection = -1;
    int selectionIndex = -1;
    ParseNode description = null;
    int valueNum = 0;

    public ValueModel(OptionParser optionParser) throws IOException, ClassNotFoundException, ParseError {
        ParseNode parseNode;
        ParseNode parseNode2 = optionParser.parse();
        if (parseNode2 == null) {
            throw new IOException("No data available");
        }
        this.name = parseNode2.getAttribute("name", "none");
        this.type = parseNode2.getAttribute("type", "Object");
        if (this.type.indexOf(".") < 0) {
            this.type = new String("java.lang." + this.type);
        }
        this.typeAsClass = Class.forName(this.type);
        Enumeration enumeration = parseNode2.getSubNodes();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                parseNode = (ParseNode)enumeration.nextElement();
                if (parseNode.getName().equals("LABEL")) {
                    this.label = parseNode.getData();
                }
                if (parseNode.getName().equals("VALUE")) {
                    ++this.valueNum;
                }
                if (!parseNode.getName().equals("DESCRIPTION")) continue;
                this.description = parseNode;
            }
        }
        if (this.valueNum > 1) {
            this.names = new String[this.valueNum];
            this.values = new Object[this.valueNum];
            enumeration = parseNode2.getSubNodes();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ParseNode parseNode3 = (ParseNode)enumeration.nextElement();
                if (!parseNode3.getName().equals("VALUE")) continue;
                this.names[n] = parseNode3.getAttribute("name", "none");
                String string = parseNode3.getData();
                String string2 = parseNode3.getAttribute("type", "literal");
                this.values[n] = this.interpretValue(string, string2);
                if (parseNode3.getAttribute("default").equals("true")) {
                    this.defaultSelection = n;
                }
                ++n;
            }
            if (this.defaultSelection < 0) {
                this.defaultSelection = 0;
            }
            this.selectionIndex = this.defaultSelection;
        } else {
            enumeration = parseNode2.getSubNodes();
            while (enumeration.hasMoreElements()) {
                parseNode = (ParseNode)enumeration.nextElement();
                if (!parseNode.getName().equals("VALUE")) continue;
                String string = parseNode.getData();
                String string3 = parseNode.getAttribute("type", "literal");
                this.theValue = this.interpretValue(string, string3);
            }
        }
    }

    public String[] getChoiceNames() {
        return this.names;
    }

    public ParseNode getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getSelectedIndex() {
        return this.selectionIndex;
    }

    public Class getType() {
        return this.typeAsClass;
    }

    public Object getValue() {
        if (this.isChoice()) {
            if (this.selectionIndex < 0) {
                return this.values[this.defaultSelection];
            }
            return this.values[this.selectionIndex];
        }
        return this.theValue;
    }

    private Object interpretValue(String string, String string2) {
        Object object = null;
        if (this.type.equals("java.lang.Class")) {
            if (string.indexOf(".") < 0) {
                string = new String("java.lang." + string);
            }
            try {
                object = Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
                object = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                object = null;
            }
            catch (InstantiationException instantiationException) {
                System.err.println(instantiationException);
                object = null;
            }
        } else if (string2.equals("eval")) {
            int n = string.lastIndexOf(46);
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(this.label) + " not a full classname");
            }
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            try {
                Class<?> clazz = Class.forName(string3);
                object = clazz.getDeclaredField(string4).get(null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
                object = null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.err.println(noSuchFieldException);
                object = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                object = null;
            }
        } else {
            try {
                Class[] classArray = new Class[]{new String().getClass()};
                Constructor constructor = this.typeAsClass.getConstructor(classArray);
                Object[] objectArray = new String[]{string};
                object = constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(invocationTargetException);
                object = null;
            }
            catch (InstantiationException instantiationException) {
                System.err.println(instantiationException);
                object = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println(noSuchMethodException);
                object = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                object = null;
            }
        }
        return object;
    }

    public boolean isChoice() {
        return this.valueNum != 1;
    }

    public boolean setValue(int n) {
        boolean bl = true;
        if (!this.isChoice() || n < 0 || n >= this.valueNum) {
            throw new IllegalArgumentException("Not a valid selection: " + n);
        }
        if (this.selectionIndex == n) {
            bl = false;
        } else {
            this.selectionIndex = n;
        }
        return bl;
    }

    public boolean setValue(Object object) throws IllegalArgumentException {
        boolean bl = true;
        if (!object.getClass().isAssignableFrom(this.typeAsClass)) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(object.getClass())) + " not assignable to " + this.type);
        }
        if (this.isChoice()) {
            int n = 0;
            while (n < this.values.length) {
                if (object.equals(this.values[n])) {
                    if (this.selectionIndex == n) {
                        bl = false;
                    } else {
                        this.selectionIndex = n;
                    }
                }
                ++n;
            }
        } else {
            if (this.theValue.equals(object)) {
                bl = false;
            }
            this.theValue = object;
        }
        return bl;
    }
}

