/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util.parser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.util.Stack;
import uk.ac.bham.clg.util.parser.ParseError;
import uk.ac.bham.clg.util.parser.ParseNode;

public abstract class SimpleParser {
    private PushbackReader input = null;
    private LineNumberReader lineNo = null;
    private Stack braceStack = null;

    public SimpleParser(InputStreamReader inputStreamReader) {
        this.lineNo = new LineNumberReader(inputStreamReader);
        this.input = new PushbackReader(this.lineNo);
        this.braceStack = new Stack();
    }

    public abstract ParseNode fillTag(ParseNode var1);

    private ParseNode getTag() throws IOException {
        ParseNode parseNode = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.readNoSpace();
        if (n < 0) {
            return null;
        }
        if ((char)n == '<') {
            String string = this.readWordNoSpace();
            parseNode = new ParseNode(string);
            String string2 = null;
            while ((n = this.readNoSpace()) >= 0 && (char)n != '>') {
                this.input.unread(n);
                string2 = this.readWordNoSpace();
                String string3 = this.readWordNoSpace();
                if (string3.equals("=")) {
                    string3 = this.readWordNoSpace();
                    parseNode.addAttribute(string2, string3);
                    string2 = null;
                } else {
                    parseNode.addAttribute(string2, "true");
                    string2 = string3;
                    if (string2.equals(">")) break;
                }
                if (this.input.ready()) continue;
                break;
            }
        } else {
            boolean bl = false;
            do {
                if ((char)n == '\n' || (char)n == '\r') {
                    n = 32;
                }
                stringBuffer.append((char)n);
                bl = Character.isWhitespace((char)n);
            } while ((n = this.input.read()) >= 0 && (char)n != '<');
            if ((char)n == '<') {
                this.input.unread(n);
            }
            parseNode = new ParseNode("#PCDATA");
            parseNode.setData(stringBuffer.toString());
        }
        return this.fillTag(parseNode);
    }

    public String getTopNode() {
        return (String)this.braceStack.peek();
    }

    public ParseNode parse() throws IOException, ParseError {
        ParseNode parseNode = this.getTag();
        if (parseNode == null) {
            return null;
        }
        if (!parseNode.isOpening()) {
            System.err.println("toplevel tag is not opening");
            return null;
        }
        this.braceStack.push(parseNode.getName());
        this.parseSubTree(parseNode);
        if (!this.braceStack.isEmpty()) {
            throw new ParseError("missing </" + this.braceStack.pop() + ">");
        }
        return parseNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSubTree(ParseNode parseNode) throws ParseError {
        try {
            ParseNode parseNode2;
            while ((parseNode2 = this.getTag()) != null) {
                if (parseNode2.isBrace() && parseNode2.isOpening()) {
                    this.braceStack.push(parseNode2.getName());
                    this.parseSubTree(parseNode2);
                }
                if (parseNode2.isClosing()) {
                    if (this.braceStack.isEmpty()) {
                        throw new ParseError("</" + parseNode2.getName() + "> not expected in " + (this.lineNo.getLineNumber() + 1));
                    }
                    String string = (String)this.braceStack.peek();
                    if (!parseNode2.getName().equals(string) && !parseNode2.getName().equals("")) throw new ParseError("</" + string + "> expected in " + (this.lineNo.getLineNumber() + 1));
                    this.braceStack.pop();
                    return;
                } else {
                    parseNode.addSubNode(parseNode2);
                    if (this.input.ready()) continue;
                }
                return;
            }
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private int readNoSpace() {
        int n;
        try {
            while (Character.isWhitespace((char)(n = this.input.read()))) {
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            n = -1;
        }
        return n;
    }

    private String readWordNoSpace() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while (this.input.ready()) {
            int n = this.input.read();
            if (n < 0) break;
            if (Character.isWhitespace((char)n) && stringBuffer.length() == 0) continue;
            if (!bl2) {
                if ((char)n == '\"') {
                    if (bl) break;
                    if (stringBuffer.length() == 0) {
                        bl = true;
                        continue;
                    }
                    this.input.unread(n);
                    break;
                }
                if ((char)n == '\\') {
                    bl2 = true;
                    continue;
                }
                if (bl) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if (Character.isWhitespace((char)n)) break;
                if ((char)n == '>' || (char)n == '<' || (char)n == '=') {
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append((char)n);
                        break;
                    }
                    this.input.unread(n);
                    break;
                }
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append((char)n);
            bl2 = false;
        }
        return stringBuffer.toString();
    }
}

