/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util.trie;

import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.ac.bham.clg.util.trie.TrieNode;

class BranchNode
extends TrieNode {
    private char[] keyLeft = null;
    private long dataPointer = -1L;
    static final int MAXWORDLENGTH = 100;

    public BranchNode(DataInput dataInput) {
        int n;
        char[] cArray = new char[100];
        int n2 = 0;
        do {
            try {
                n = dataInput.readUnsignedByte();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                n = -1;
            }
            if (n == -1) {
                n = 0;
            }
            cArray[n2++] = (char)(n & 0xFF);
        } while (n != 0);
        this.keyLeft = new char[n2];
        System.arraycopy(cArray, 0, this.keyLeft, 0, n2 - 1);
        try {
            this.dataPointer = dataInput.readLong();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            this.dataPointer = -1L;
        }
    }

    public BranchNode(char[] cArray, int n, long l) {
        this.keyLeft = new char[cArray.length - n];
        int n2 = n;
        while (n2 < cArray.length) {
            this.keyLeft[n2 - n] = cArray[n2];
            ++n2;
        }
        this.dataPointer = l;
    }

    public long getDataPointer() {
        return this.dataPointer;
    }

    public char getIndex() {
        return this.keyLeft[0];
    }

    public char[] getKey() {
        return this.keyLeft;
    }

    public void setDataPointer(long l) {
        this.dataPointer = l;
    }

    public void shiftKey() {
        char[] cArray = new char[this.keyLeft.length - 1];
        System.arraycopy(this.keyLeft, 1, cArray, 0, cArray.length);
        this.keyLeft = cArray;
    }

    public String toString() {
        return new String("BN: " + this.keyLeft + " -> " + this.dataPointer);
    }

    public void writeNode(RandomAccessFile randomAccessFile, long l) throws IOException {
        try {
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            throw new IOException("BranchNode seek(" + l + ") failed");
        }
        try {
            randomAccessFile.writeByte(1);
            if (this.keyLeft.length > 0) {
                int n = 0;
                while (n < this.keyLeft.length) {
                    randomAccessFile.writeByte(this.keyLeft[n]);
                    ++n;
                }
            } else {
                randomAccessFile.writeByte(0);
            }
            randomAccessFile.writeLong(this.dataPointer);
        }
        catch (IOException iOException) {
            throw new IOException("BranchNode write failed");
        }
    }
}

