/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util.trie;

import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.ac.bham.clg.util.trie.TrieNode;

class PointerNode
extends TrieNode {
    private long[] pointers = new long[256];

    public PointerNode() {
        int n = 0;
        while (n < this.pointers.length) {
            this.pointers[n] = -1L;
            ++n;
        }
    }

    public PointerNode(DataInput dataInput) {
        int n = 0;
        while (n < this.pointers.length) {
            try {
                this.pointers[n] = dataInput.readLong();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                this.pointers[n] = -1L;
            }
            ++n;
        }
    }

    public long getPointer(int n) {
        if (n >= 0 && n < this.pointers.length) {
            return this.pointers[n];
        }
        return 0L;
    }

    public void setPointer(int n, long l) {
        if (n >= 0 && n < this.pointers.length) {
            this.pointers[n] = l;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.pointers.length) {
            if (this.pointers[n] > -1L) {
                stringBuffer.append(String.valueOf((char)n) + " " + n + ". -> " + this.pointers[n] + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void writeNode(RandomAccessFile randomAccessFile, long l) throws IOException {
        try {
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            throw new IOException("PointerNode: seek(" + l + ") failed");
        }
        try {
            randomAccessFile.writeByte(0);
            int n = 0;
            while (n < this.pointers.length) {
                randomAccessFile.writeLong(this.pointers[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new IOException("PointerNode: write failed");
        }
    }
}

