/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util.trie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import uk.ac.bham.clg.util.UTF;
import uk.ac.bham.clg.util.trie.BranchNode;
import uk.ac.bham.clg.util.trie.PointerNode;
import uk.ac.bham.clg.util.trie.TrieNode;

public class Trie
extends Dictionary {
    private String fileName = null;
    private RandomAccessFile trieFile = null;
    private RandomAccessFile dataFile = null;
    private PointerNode root = null;
    private String mode = "r";
    private int size = 0;
    private long rootPosition = 0L;
    private Trie copyTrie = null;
    static final boolean DEBUG = false;

    public Trie(String string, String string2) {
        this(string, string2, 4L);
    }

    private Trie(String string, String string2, long l) {
        this.mode = string2;
        this.fileName = string;
        this.rootPosition = l;
        try {
            this.trieFile = new RandomAccessFile(String.valueOf(string) + ".trie", string2);
            this.dataFile = new RandomAccessFile(String.valueOf(string) + ".data", string2);
            if (this.trieFile.length() == 0L && string2.equals("rw")) {
                int n = 0;
                this.trieFile.writeInt(n);
                this.root = new PointerNode();
                l = 4L;
                this.root.writeNode(this.trieFile, l);
            } else {
                this.size = this.trieFile.readInt();
                this.root = (PointerNode)this.readNode(l);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private Object array2obj(byte[] byArray) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return null;
    }

    private void collectElements(TrieNode trieNode, Vector vector) {
        BranchNode branchNode;
        long l;
        if (trieNode instanceof PointerNode) {
            PointerNode pointerNode = (PointerNode)trieNode;
            int n = 0;
            while (pointerNode.getPointer(n) != 0L) {
                long l2 = pointerNode.getPointer(n);
                if (l2 > 0L) {
                    try {
                        TrieNode trieNode2 = this.readNode(l2);
                        this.collectElements(trieNode2, vector);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                    }
                }
                ++n;
            }
        } else if (trieNode instanceof BranchNode && (l = (branchNode = (BranchNode)trieNode).getDataPointer()) > -1L) {
            vector.addElement(new Long(l));
        }
    }

    private void collectKeys(TrieNode trieNode, int n, char[] cArray, Vector vector) {
        block9: {
            char[] cArray2;
            BranchNode branchNode;
            block10: {
                block8: {
                    if (!(trieNode instanceof PointerNode)) break block8;
                    PointerNode pointerNode = (PointerNode)trieNode;
                    char[] cArray3 = new char[n + 1];
                    System.arraycopy(cArray, 0, cArray3, 0, n);
                    int n2 = 0;
                    while (pointerNode.getPointer(n2) != 0L) {
                        long l = pointerNode.getPointer(n2);
                        if (l > 0L) {
                            try {
                                cArray3[n] = (char)n2;
                                TrieNode trieNode2 = this.readNode(l);
                                this.collectKeys(trieNode2, n + 1, cArray3, vector);
                            }
                            catch (IOException iOException) {
                                System.err.println(iOException);
                            }
                        }
                        ++n2;
                    }
                    break block9;
                }
                if (!(trieNode instanceof BranchNode) || (branchNode = (BranchNode)trieNode).getDataPointer() <= -1L) break block9;
                char[] cArray4 = branchNode.getKey();
                if (cArray4[0] == '\u0000') {
                    cArray2 = cArray;
                } else {
                    cArray2 = new char[cArray4.length + n + 1];
                    System.arraycopy(cArray, 0, cArray2, 0, n);
                    System.arraycopy(cArray4, 0, cArray2, n, cArray4.length);
                }
                if (vector == null) break block10;
                vector.addElement(UTF.toString(cArray2));
                break block9;
            }
            if (this.copyTrie == null) break block9;
            try {
                Object object = this.retrieveData(branchNode.getDataPointer());
                this.copyTrie.put(cArray2, object);
            }
            catch (IOException iOException) {
                System.err.println("gc(): " + iOException);
            }
        }
    }

    public boolean contains(Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!e.equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        String string = object.toString();
        return this.containsKey(string);
    }

    public boolean containsKey(String string) {
        try {
            char[] cArray = UTF.toArray(string);
            long l = this.searchKey(cArray, 0, this.root);
            if (l != -1L) {
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return false;
    }

    public void copy(String string) {
        this.copyTrie = new Trie(string, "rw");
        char[] cArray = new char[]{};
        this.collectKeys(this.root, 0, cArray, null);
        this.copyTrie = null;
    }

    public Enumeration elements() {
        Vector vector = new Vector(this.size);
        this.collectElements(this.root, vector);
        return new ElementEnumerator(this, vector);
    }

    public void gc() throws IOException {
        String string = new String("triecopy");
        this.copy(string);
        File file = new File(String.valueOf(string) + ".trie");
        File file2 = new File(String.valueOf(this.fileName) + ".trie");
        file.renameTo(file2);
        file = new File(String.valueOf(string) + ".data");
        file2 = new File(String.valueOf(this.fileName) + ".data");
        file.renameTo(file2);
        this.trieFile = new RandomAccessFile(String.valueOf(this.fileName) + ".trie", this.mode);
        this.dataFile = new RandomAccessFile(String.valueOf(this.fileName) + ".data", this.mode);
    }

    public Object get(Object object) {
        String string = object.toString();
        return this.get(string);
    }

    public Object get(String string) {
        try {
            char[] cArray = UTF.toArray(string);
            long l = this.searchKey(cArray, 0, this.root);
            if (l == -1L) {
                return null;
            }
            return this.retrieveData(l);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Object insertKey(PointerNode pointerNode, long l, char[] cArray, int n, byte[] byArray) throws IOException {
        if (pointerNode.getPointer(cArray[n]) == -1L) {
            long l2 = this.trieFile.length();
            pointerNode.setPointer(cArray[n], l2);
            pointerNode.writeNode(this.trieFile, l);
            long l3 = this.writeData(byArray);
            BranchNode branchNode = new BranchNode(cArray, n + 1, l3);
            branchNode.writeNode(this.trieFile, l2);
            return null;
        }
        long l4 = pointerNode.getPointer(cArray[n]);
        TrieNode trieNode = this.readNode(l4);
        if (trieNode instanceof PointerNode) {
            return this.insertKey((PointerNode)trieNode, l4, cArray, n + 1, byArray);
        }
        BranchNode branchNode = (BranchNode)trieNode;
        char[] cArray2 = branchNode.getKey();
        boolean bl = true;
        if (cArray2.length == cArray.length - n) {
            int n2 = 0;
            while (bl && n2 < cArray2.length) {
                if (cArray2[n2] != cArray[n + n2]) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                Object object = this.retrieveData(branchNode.getDataPointer());
                branchNode.setDataPointer(this.writeData(byArray));
                branchNode.writeNode(this.trieFile, l4);
                return object;
            }
        }
        PointerNode pointerNode2 = new PointerNode();
        pointerNode2.setPointer(branchNode.getIndex(), l4);
        branchNode.shiftKey();
        branchNode.writeNode(this.trieFile, l4);
        long l5 = this.trieFile.length();
        pointerNode2.writeNode(this.trieFile, l5);
        pointerNode.setPointer(cArray[n], l5);
        pointerNode.writeNode(this.trieFile, l);
        return this.insertKey(pointerNode, l, cArray, n, byArray);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        Vector vector = new Vector(this.size);
        char[] cArray = new char[]{};
        this.collectKeys(this.root, 0, cArray, vector);
        return vector.elements();
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2 = new String[]{"one", "two", "\u00c5ardvark", "\u00a5", "Pounds", "one two", "one too many", "one"};
        String[] stringArray3 = new String[]{"1", "2", "A funny creature", "yen", "\u00a3", "overlapping `one'", "more overlap", "double entry!"};
        if (stringArray.length == 0) {
            System.err.println("usage: java Trie <triename>");
            System.exit(0);
        }
        Trie trie = new Trie(stringArray[0], "rw");
        System.out.println("---CREATING");
        int n = 0;
        while (n < stringArray2.length) {
            trie.put(stringArray2[n], (Object)stringArray3[n]);
            System.out.println(String.valueOf(stringArray2[n]) + ": " + stringArray3[n] + "; size: " + trie.size());
            ++n;
        }
        System.out.println("---KEYS");
        Enumeration enumeration = trie.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println((String)enumeration.nextElement());
        }
        System.out.println("---ELEMENTS");
        enumeration = trie.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println((String)enumeration.nextElement());
        }
        System.out.println("---TESTING");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string = (String)trie.get(stringArray2[n2]);
            System.out.println(String.valueOf(stringArray2[n2]) + ": " + string);
            ++n2;
        }
        System.out.println("---GARBAGE COLLECTION");
        trie.gc();
        System.out.println("---FINISHED");
    }

    private byte[] obj2array(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
    }

    public Object put(Object object, Object object2) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException("Trie.put with null key");
        }
        if (object2 == null) {
            throw new NullPointerException("Trie.put with null data");
        }
        String string = object.toString();
        return this.put(string, object2);
    }

    public Object put(String string, Object object) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Trie.put with null key");
        }
        if (object == null) {
            throw new NullPointerException("Trie.put with null data");
        }
        try {
            char[] cArray = UTF.toArray(string);
            byte[] byArray = this.obj2array(object);
            Object object2 = this.insertKey(this.root, this.rootPosition, cArray, 0, byArray);
            if (object2 == null) {
                this.setSize(this.size + 1);
            }
            return object2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private TrieNode readNode(long l) throws IOException {
        try {
            this.trieFile.seek(l);
        }
        catch (IOException iOException) {
            throw new IOException(String.valueOf(this.fileName) + " readNode.seek(" + l + ") failed");
        }
        byte by = this.trieFile.readByte();
        TrieNode trieNode = null;
        switch (by) {
            case 0: {
                trieNode = new PointerNode(this.trieFile);
                break;
            }
            case 1: {
                trieNode = new BranchNode(this.trieFile);
                break;
            }
            default: {
                throw new IOException("Illegal trie value (" + by + ") at position " + l);
            }
        }
        return trieNode;
    }

    public Object remove(Object object) {
        try {
            char[] cArray = UTF.toArray(object.toString());
            long l = this.searchKey(cArray, 0, this.root);
            if (l > -1L) {
                this.setSize(this.size - 1);
                return this.insertKey(this.root, 0L, cArray, 0, null);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return null;
    }

    protected Object retrieveData(long l) throws IOException {
        try {
            this.dataFile.seek(l);
            short s = this.dataFile.readShort();
            byte[] byArray = new byte[s];
            this.dataFile.readFully(byArray);
            return this.array2obj(byArray);
        }
        catch (IOException iOException) {
            throw new IOException("dataFile.read(" + l + ") failed");
        }
    }

    private long searchKey(char[] cArray, int n, PointerNode pointerNode) throws IOException {
        long l = pointerNode.getPointer(cArray[n]);
        if (l < 1L) {
            return -1L;
        }
        TrieNode trieNode = this.readNode(l);
        if (trieNode instanceof PointerNode) {
            PointerNode pointerNode2 = (PointerNode)trieNode;
            if (cArray[n] != '\u0000') {
                ++n;
            }
            return this.searchKey(cArray, n, pointerNode2);
        }
        if (trieNode instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)trieNode;
            char[] cArray2 = branchNode.getKey();
            boolean bl = true;
            int n2 = 0;
            while (bl && cArray2[n2] != '\u0000') {
                if (cArray2[n2] != cArray[n + n2 + 1]) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                return branchNode.getDataPointer();
            }
            return -1L;
        }
        System.err.println("searchKey: wrong data type " + trieNode.getClass().getName());
        return -1L;
    }

    private void setSize(int n) {
        this.size = n;
        try {
            this.trieFile.seek(0L);
            this.trieFile.writeInt(this.size);
        }
        catch (IOException iOException) {
            System.err.println("setSize(): " + iOException);
        }
    }

    public int size() {
        return this.size;
    }

    private long writeData(byte[] byArray) {
        if (byArray == null) {
            return -1L;
        }
        long l = -1L;
        try {
            l = this.dataFile.length();
            this.dataFile.seek(l);
            this.dataFile.writeShort((short)byArray.length);
            this.dataFile.write(byArray);
            return l;
        }
        catch (IOException iOException) {
            System.err.println("writeData " + l + ": " + iOException);
            return -1L;
        }
    }

    private class ElementEnumerator
    implements Enumeration {
        private long[] storage = null;
        private int index = -1;
        private Trie trie = null;

        public ElementEnumerator(Trie trie2, Vector vector) {
            this.storage = new long[vector.size()];
            this.index = 0;
            this.trie = trie2;
            int n = 0;
            while (n < this.storage.length) {
                this.storage[n] = (Long)vector.elementAt(n);
                ++n;
            }
        }

        public boolean hasMoreElements() {
            return this.index < this.storage.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.hasMoreElements()) {
                try {
                    return this.trie.retrieveData(this.storage[this.index++]);
                }
                catch (IOException iOException) {
                    throw new NoSuchElementException();
                }
            }
            throw new NoSuchElementException();
        }
    }
}

