/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.util.trie;

import java.io.IOException;
import java.io.RandomAccessFile;
import uk.ac.bham.clg.util.trie.BranchNode;
import uk.ac.bham.clg.util.trie.PointerNode;
import uk.ac.bham.clg.util.trie.TrieNode;

class TrieTest {
    TrieTest() {
    }

    public static void main(String[] stringArray) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
        TrieTest.traverseNode(randomAccessFile, 4L);
    }

    public static void traverseNode(RandomAccessFile randomAccessFile, long l) throws IOException {
        TrieNode trieNode;
        randomAccessFile.seek(l);
        byte by = randomAccessFile.readByte();
        switch (by) {
            case 0: {
                trieNode = new PointerNode(randomAccessFile);
                break;
            }
            case 1: {
                trieNode = new BranchNode(randomAccessFile);
                break;
            }
            default: {
                throw new IOException("Illegal trie value " + by);
            }
        }
        System.out.println("-----------\n" + l + ":\n" + trieNode);
        if (trieNode instanceof PointerNode) {
            long l2 = -1L;
            int n = 0;
            while (l2 != 0L) {
                l2 = ((PointerNode)trieNode).getPointer(n);
                if (l2 > 0L) {
                    TrieTest.traverseNode(randomAccessFile, l2);
                }
                ++n;
            }
        }
    }
}

