
Conversion table for Kwik user font to SILDoulos IPA93

;----------------------------------------------------------------------------
; Vowel symbols (from front high to low to back high)
;
i		;	073	Small Capital I
y		;	089	Small Capital Y
#		;	079	Slashed O
e		;	069	Epsilon
O		;	191	O-E Digraph
E		;	175	Small Capital O-E
;
<		;	065	Cursive A
>		;	129	Turned Cursive A
o		;	141	Open O
u		;	085	Short U
		;	086	Cursive V
m		;	181	Upside-down M
;
;----------------------------------------------------------------------------
; High central vowels
;
*		;	246	Barred I
+		;	172	Barred U
;
;----------------------------------------------------------------------------
; Centralised vowels
;
q		;	171	Schwa
=		;	206	Reversed Epsilon
0		;	080	Barred O
v		;	195	Turned V
a		;	140	Turned A
;
;----------------------------------------------------------------------------
; Consonants (arranged according to place of articulation)
;
0		;	184	Phi
b		;	066	Beta
w		;	227	Turned W (voiced labio-velar fricative)
M		;	077	Left-tail M at right (German _fnf_)
;
2		;	084	Theta
3		;	068	Eth
;
6		;	255	Right-tail T (retroflex t)
7		;	234	Right-tail D (retroflex d)
;
s		;	167	Right-Tail S (Swedish _kurs_)
$		;	083	Esh
		;	254	Curly-tail C
c		;	067	C Cedilla
f		;	239	Barred Dotless J (voiced palatal stop)
A		;	252	Curly-tail Z
z		;	189	Right-tail Z
g		;	090	Yogh
		;	198	Curly-tail J (fricative j)
;
N		;	248	Left-tail N at left (palatal n)
L		;	180	Turned Y (palatal l)
(		;	241	Right-tail L (retroflex l)
1		;	194	Belted L (velarised l)
3		;	076	L-Yogh Digraph (lateral fricative)
;
r		;	168	Turned R (continuant)
4		;	082	Fish-hook R (tap)
5		;	211	Turned R, Right Tail (retroflex continuant)
Z		;	210	Inverted Small Capital R
;
X		;	088	Chi (uvular fricative)
J		;	196	Gamma
n		;	078	Eng
;
H		;	250	Hooktop H (voiced h)
H		;	238	Hooked Heng (Swedish _sjuta_)
h		;	231	Turned H (French _huit_)
m		;	229	Upside-down M, Right Leg
;
?		;	063	Glottal Stop
?		;	192	Reversed Glottal Stop
;
;--------------------------------------------------------------------
; Superscript letters
;
,		;	072	Superscript H
j		;	074	Superscript J
x		;	236	Superscript Gamma
		;	087	Superscript W
5		;	179	Superscript Reversed Glottal Stop
;
;--------------------------------------------------------------------
; Diacritics
;
:		;	249	Length Mark
;		;	062	Half-length Mark
}		;	162	Lowering Sign (lowered articulation)
{		;	163	Raising Sign (raised articulation)
^		;	177	Subscript Plus (fronted articulation)
_		;	220	Macron (retracted articulation)
/		;	200	Vertical Stroke (primary stress)
\		;	199	Vertical Stroke (secondary stress)
		;	155	Down Arrow
		;	139	Up Arrow
E		;	223	Left Arrow
F		;	224	Right Arrow
#		;	156	Not-equals Sign
		;	144	Prime
;
;--------------------------------------------------------------------
; Symbols from KwikText not in SILDoulos IPA93 as single symbols
;
8		;	187	Lenited t
9		;	187	Lenited d
t		;	53	Dental t
d		;	53	Dental d
(		;	96	Syllabic n
)		;	96	Syllabic l
-		;	168	Superscript continuant r
		;	211	Superscript retroflex r
Q		;	171+168	Rhotacised schwa
"		;	190	Palatality mark
		;	249	C with hacek
		;	062	S with hacek
		;	124	Z with hacek
		;	38	J with hacek
%		;	38	Voiceless n
Y		;	56	Voiceless eng
l		;	38	Voiceless l
k		;	38	Voiceless r
T		;	242	Velarised t
B		;	242	Velarised n
S		;	242	Velarised s
x		;	168+242	Velarised r
;
U		;	195+95	Diaresis turned V
%		;	141+95	Diaresis open O
*		;	45	O and subscript diaresis
;
_		;	073	Small Capital I
.		;	069	Epsilon
I		;	065	Cursive A
\		;	141	Open O
;		;	111	Normal O
w		;	119	W
;
		;	205	I with acute	
		;	193	A with acute
		;	211	O with acute
		;	218	U with acute
;
	 	;	Italic I with acute
	 	;	Italic A with acute
	 	;	Italic O with acute
	 	;	Italic U with acute
;
P		;	222	Uppercase Thorn
p		;	254	Lowercase Thorn
G		;	90	Uppercase Yogh (not available!)
g		;	90	Lowercase Yogh
D		;	208	Uppercase Eth
C		;	240	Lowercase Eth
	 	;	Italic Uppercase Thorn
	 	;	Italic Lowercase Thorn
		;	Italic Uppercase Yogh (not available!)
	 	;	Italic Lowercase Yogh
	 	;	Italic Uppercase Eth
	 	;	Italic Lowercase Eth
	 	;	Italic Eng
;
`		;	35	Italic Y with macron
	 	;	220	Italic I with macron
		;	35	Italic E with macron
		;	81+35	Italic ASH with macron
		;	35	Italic A with macron
		;	35	Italic O with macron
		;	35	Italic U with macron
		;	171	Italic Schwa
;
		;	35+55	Italic E with macron + hook
	 	;	35+55	Italic O with macron + hook
;
		;	081	Ash
		;	124	Corner (unreleased stop)
;
; End of File KWIK_SIL.TST
;
