;
; General remarks on the structure of a form file for Lexa Form
;------------------------------------------------------------
;
; Note: Any line which begins with a semi-colon is interpreted as a comment
; by Lexa Form and skipped. Be careful not to have any empty lines in a form
; file (unless explicitly advised to do so) as this leads to confusion. Any
; given line is either (i) a comment or (ii) an item of information for the
; current form.
;
; A form file can be edited with Lexa Text (or any text editor). Form files
; are pure ASCII texts.
;
; It is not obligatory to have both a Title and a Field together. If you
; wish to have just a Title, declare the Field length to be 0 and vice
; versa to suppress a Title.
;
; In order for a form to be printed successfully, each field must have a
; row coordinate which is greater than the previous one. Equally column
; coordinates must be in ascending numerical order. The reason for this is
; that one cannot assume that printers can move backwards during the printing
; process. If a field row coordinate is smaller than its predecessor then
; Lexa Form takes the latter value and adds 1 to it (i.e. prints the current
; field on the next line). Columns with smaller values than a previous one
; are simply incremented by 1 in a similar fashion.
;
; Remember that the row and column positions which you specify for a given
; field refer to the page coordinates. You may scroll horizontally in any
; form which is longer than a screenful. Fields do not have to be on con-
; secutive lines. A title does not have to be on the same line as the field
; to which it belongs (it may be above or below it). You may scroll horiz-
; ontally in any field input line by specifying a Field Window Width which
; is smaller than the Field Length.
;
; When specifying the use of a header and/or footer bear in mind that the
; page length (specified in the print menu or in this form file) refers to 
; the length of the printed page WITHOUT headers or footers. For example if
; your printer can print 60 lines in a given typeface and you have a header
; of 3 lines and a footer of 2 then the maximum page length is 55 lines. The
; latter includes titles, fields (and any empty lines between them) along 
; with the lines of a possible file printed as part of the form as a result
; of a title consisting of a file name in double angular brackets.
;
; If a title or a field exceeds the legal maximum then it is truncated to
; this. Note the following limits:
;
;	Maximum length of title:  64
;	Maximum length of field:  128
;
; 	Maximum length of text title:  64
; 	Maximum length of text line:   160
; 	Maximum number of text lines:  12
;
;	Maximum number of fields per form: 80
;
;
; Note that a form is not restricted to a single page. If the number of 
; fields, any additional files to be printed on the form and a possible
; header or footer result in a length greater than one page then the form
; will be continued on the next and so on until all the data of which the
; form consists has been printed. Equally there is no restriction on the
; size of a printed page. Normal forms will fit on A4 size paper, A3 can
; be used for forms with wides lines and many rows.
;
; The style and/or typeface to be used for both titles and field contents
; depends on the command which is to be found in the Printer Command File.
; 
; Note: To reduce the size of a form file you may remove all the comments
; as these are of no relevance to the acceptance of the file by Lexa Form
; (compare MASTER.FRM and NO_COMM.FRM). This can be done by simply saving
; the file with comments from the form editing level when returning to
; the desktop.
;
; When developing a prototype of a form you should first of all design a
; master form with all the comments necessary for you to recognize its
; structure easily (at some later stage). You can take the present file
; as a starting point for convenience sake. During the test phase it is
; recommended outputting the form to disk (this saves time and paper). 
; Once the form has reached its final shape you can remove the comments
; (see last paragraph) and duplicate as necessary for each new set of data.
;
;
;----------------------------------------------------------------------------
;
; Item 1:  Is there a stretch of text to be included on form?
;
1
;
; Item 2:  Position of text (1 ? Bottom of form, 0 ? Top of form)
;
1
;
; Item 3:  Field total for entire form
;
33
;
;----------------------------------------------------------------------------;
; Item 4: Required national date format (use for date strings in form!)
;
; Key:
; 	0  ?  American  (MM/DD/YYY)
; 	1  ?  British   (DD/MM/YYY)
; 	2  ?  German    (DD.MM.YYY)
;
2
;
;----------------------------------------------------------------------------;
; Item 5: Use 50-line VGA display?
;
0
;
;----------------------------------------------------------------------------;
; Item 6: Name of file with text lines (code block via F2)
;
SNIPPET.TXT
;
;----------------------------------------------------------------------------;
; Item 7: Name of delimited text file for import into database
;
DELIMIT.TXT
;
;----------------------------------------------------------------------------;
; Item 8: Name of user editor
;
LTEXT
;
;----------------------------------------------------------------------------;
;
;		->   Information concerning form structure   <-
;
;----------------------------------------------------------------------------;
;
; There now follows the definitions of the individual fields of the form
; Note that each field contains the following 9 items of information:
;  
;	(1)	Title length
;	(2) 	Title name
; 	(3) 	Title start row
; 	(4) 	Title start column
; 	(5) 	Title style
; 	(6) 	Field length
; 	(7) 	Field window width
; 	(8) 	Field contents
; 	(9) 	Field start row
; 	(10) 	Field start column
; 	(11) 	Field style
;
;
; Note: You may suppress a title or field by declaring its length as 0.
; In such cases there must be no further information on the title / field.
; Study the examples below to see how this works.
;
;----------------------------------------------------------------------------
;
; FIELD NO. 1
;
; (1) Title length:
;
28
;
; (2) Title name:
;
Section 1:  Name and Address
;
; (3) Title start row:
;
1
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
0
;
; (7) Field window width:
;
0
;
; (8) Field contents:
;
0
;
; (9) Field start row:
;
0
;
; (10) Field start col:
;
0
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 2
;
; (1) Title length:
;
7
;
; (2) Title name:
;
Surname
;
; (3) Title start row:
;
3
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
23
;
; (7) Field window width:
;
23
;
; (8) Field contents:
;
Murphy
;
; (9) Field start row:
;
3
;
; (10) Field start col:
;
10
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 3
;
; (1) Title length:
;
10
;
; (2) Title name:
;
Firstname
;
; (3) Title start row:
;
3
;
; (4) Title start col:
;
37
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
20
;
; (7) Field window width:
;
20
;
; (8) Field contents:
;
Patrick
;
; (9) Field start row:
;
3
;
; (10) Field start col:
;
48
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 4
;
; (1) Title length:
;
6
;
; (2) Title name:
;
Street
;
; (3) Title start row:
;
5
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
24
;
; (7) Field window width:
;
24
;
; (8) Field contents:
;
O'Connell St.
;
; (9) Field start row:
;
5
;
; (10) Field start col:
;
9
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 5
;
; (1) Title length:
;
5
;
; (2) Title name:
;
Number
;
; (3) Title start row:
;
5
;
; (4) Title start col:
;
37
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
8
;
; (7) Field window width:
;
8
;
; (8) Field contents:
;
21
;
; (9) Field start row:
;
5
;
; (10) Field start col:
;
45
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 6
;
; (1) Title length:
;
4
;
; (2) Title name:
;
City
;
; (3) Title start row:
;
7
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
24
;
; (7) Field window width:
;
14
;
; (8) Field contents:
;
Galway
;
; (9) Field start row:
;
7
;
; (10) Field start col:
;
7
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 7
;
; (1) Title length:
;
8
;
; (2) Title name:
;
Zip Code
;
; (3) Title start row:
;
7
;
; (4) Title start col:
;
25
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
13
;
; (7) Field window width:
;
13
;
; (8) Field contents:
;
(none)
;
; (9) Field start row:
;
7
;
; (10) Field start col:
;
34
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 8
;
; (1) Title length:
;
7
;
; (2) Title name:
;
Country
;
; (3) Title start row:
;
7
;
; (4) Title start col:
;
50
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
24
;
; (7) Field window width:
;
18
;
; (8) Field contents:
;
Ireland
;
; (9) Field start row:
;
7
;
; (10) Field start col:
;
59
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 9
;
; (1) Title length:
;
8
;
; (2) Title name:
;
Tel.Code
;
; (3) Title start row:
;
9
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
11
;
; (7) Field window width:
;
11
;
; (8) Field contents:
;
00 353 61
;
; (9) Field start row:
;
9
;
; (10) Field start col:
;
11
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 10
;
; (1) Title length:
;
7
;
; (2) Title name:
;
Tel.No.
;
; (3) Title start row:
;
9
;
; (4) Title start col:
;
25
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
13
;
; (7) Field window width:
;
13
;
; (8) Field contents:
;
7 34 88
;
; (9) Field start row:
;
9
;
; (10) Field start col:
;
34
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 11
;
; (1) Title length:
;
34
;
; (2) Title name:
;
Section 2:  Educational Background
;
; (3) Title start row:
;
13
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
0
;
; (7) Field window width:
;
0
;
; (8) Field contents:
;
0
;
; (9) Field start row:
;
0
;
; (10) Field start col:
;
0
;
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 12
;
; (1) Title length:
;
12
;
; (2) Title name:
;
master.txt
;
; (3) Title start row:
;
13
;
; (4) Title start col:
;
40
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
0
;
; (7) Field window width:
;
0
;
; (8) Field contents:
;
0
;
; (9) Field start row:
;
0
;
; (10) Field start col:
;
0
;
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 13
;
; (1) Title length:
;
6
;
; (2) Title name:
;
School
;
; (3) Title start row:
;
16
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
20
;
; (7) Field window width:
;
20
;
; (8) Field contents:
;
Connemara Park
;
; (9) Field start row:
;
16
;
; (10) Field start col:
;
9
;
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 14
;
; (1) Title length:
;
10
;
; (2) Title name:
;
University
;
; (3) Title start row:
;
16
;
; (4) Title start col:
;
34
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
40
;
; (7) Field window width:
;
30
;
; (8) Field contents:
;
University College Galway
;
; (9) Field start row:
;
16
;
; (10) Field start col:
;
46
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 15
;
; (1) Title length:
;
6
;
; (2) Title name:
;
Degree
;
; (3) Title start row:
;
18
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
24
;
; (7) Field window width:
;
17
;
; (8) Field contents:
;
Master of Arts
;
; (9) Field start row:
;
18
;
; (10) Field start col:
;
9
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 16
;
; (1) Title length:
;
8
;
; (2) Title name:
;
Subjects
;
; (3) Title start row:
;
18
;
; (4) Title start col:
;
30
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
64
;
; (7) Field window width:
;
30
;
; (8) Field contents:
;
Archaeology and Prehistory
;
; (9) Field start row:
;
18
;
; (10) Field start col:
;
40
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 17
;
; (1) Title length:
;
10
;
; (2) Title name:
;
Profession
;
; (3) Title start row:
;
20
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
56
;
; (7) Field window width:
;
26
;
; (8) Field contents:
;
Excavator
;
; (9) Field start row:
;
20
;
; (10) Field start col:
;
12
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 18
;
; (1) Title length:
;
8
;
; (2) Title name:
;
Position
;
; (3) Title start row:
;
20
;
; (4) Title start col:
;
42
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
36
;
; (7) Field window width:
;
24
;
; (8) Field contents:
;
Foreman
;
; (9) Field start row:
;
20
;
; (10) Field start col:
;
52
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 19
;
; (1) Title length:
;
22
;
; (2) Title name:
;
Section 3:  Appearence
;
; (3) Title start row:
;
24
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
0
;
; (7) Field window width:
;
0
;
; (8) Field contents:
;
0
;
; (9) Field start row:
;
0
;
; (10) Field start col:
;
0
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 20
;
; (1) Title length:
;
6
;
; (2) Title name:
;
Height
;
; (3) Title start row:
;
26
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
13
;
; (7) Field window width:
;
13
;
; (8) Field contents:
;
5' 10"
;
; (9) Field start row:
;
26
;
; (10) Field start col:
;
8
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 21
;
; (1) Title length:
;
6
;
; (2) Title name:
;
Weight
;
; (3) Title start row:
;
26
;
; (4) Title start col:
;
25
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
20
;
; (7) Field window width:
;
20
;
; (8) Field contents:
;
12 stone
;
; (9) Field start row:
;
26
;
; (10) Field start col:
;
32
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 22
;
; (1) Title length:
;
11
;
; (2) Title name:
;
Hair Colour
;
; (3) Title start row:
;
28
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
23
;
; (7) Field window width:
;
12
;
; (8) Field contents:
;
Bright Red
;
; (9) Field start row:
;
28
;
; (10) Field start col:
;
13
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 23
;
; (1) Title length:
;
10
;
; (2) Title name:
;
Eye Colour
;
; (3) Title start row:
;
28
;
; (4) Title start col:
;
28
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
24
;
; (7) Field window width:
;
13
;
; (8) Field contents:
;
Green
;
; (9) Field start row:
;
28
;
; (10) Field start col:
;
39
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 24
;
; (1) Title length:
;
20
;
; (2) Title name:
;
Distinctive Features
;
; (3) Title start row:
;
30
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
52
;
; (7) Field window width:
;
52
;
; (8) Field contents:
;
Over 1 million freckles
;
; (9) Field start row:
;
30
;
; (10) Field start col:
;
22
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 25
;
; (1) Title length:
;
29
;
; (2) Title name:
;
Section 4:  Details of Health
;
; (3) Title start row:
;
34
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
0
;
; (7) Field window width:
;
0
;
; (8) Field contents:
;
0
;
; (9) Field start row:
;
0
;
; (10) Field start col:
;
0
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 26
;
; (1) Title length:
;
26
;
; (2) Title name:
;
Major Diseases in the Past
;
; (3) Title start row:
;
36
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
74
;
; (7) Field window width:
;
74
;
; (8) Field contents:
;
Various hallucinatory disorders
;
; (9) Field start row:
;
37
;
; (10) Field start col:
;
1
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 27
;
; (1) Title length:
;
35
;
; (2) Title name:
;
Permanent Handicaps or Disablements
;
; (3) Title start row:
;
39
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
74
;
; (7) Field window width:
;
74
;
; (8) Field contents:
;
Computeritis
;
; (9) Field start row:
;
40
;
; (10) Field start col:
;
1
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 28
;
; (1) Title length:
;
31
;
; (2) Title name:
;
Section 5:  Private Information
;
; (3) Title start row:
;
44
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
0
;
; (7) Field window width:
;
0
;
; (8) Field contents:
;
0
;
; (9) Field start row:
;
0
;
; (10) Field start col:
;
0
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 29
;
; (1) Title length:
;
6
;
; (2) Title name:
;
Status
;
; (3) Title start row:
;
46
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
16
;
; (7) Field window width:
;
16
;
; (8) Field contents:
;
Married
;
; (9) Field start row:
;
46
;
; (10) Field start col:
;
8
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 30
;
; (1) Title length:
;
3
;
; (2) Title name:
;
Age
;
; (3) Title start row:
;
46
;
; (4) Title start col:
;
28
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
6
;
; (7) Field window width:
;
6
;
; (8) Field contents:
;
35
;
; (9) Field start row:
;
46
;
; (10) Field start col:
;
32
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 31
;
; (1) Title length:
;
15
;
; (2) Title name:
;
Children
;
; (3) Title start row:
;
46
;
; (4) Title start col:
;
45
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
6
;
; (7) Field window width:
;
6
;
; (8) Field contents:
;
7
;
; (9) Field start row:
;
46
;
; (10) Field start col:
;
56
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 32
;
; (1) Title length:
;
7
;
; (2) Title name:
;
Hobbies
;
; (3) Title start row:
;
48
;
; (4) Title start col:
;
1
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
48
;
; (7) Field window width:
;
20
;
; (8) Field contents:
;
Scuba diving for sunken treasures
;
; (9) Field start row:
;
48
;
; (10) Field start col:
;
9
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; FIELD NO. 33
;
; (1) Title length:
;
16
;
; (2) Title name:
;
Favourite Cheese
;
; (3) Title start row:
;
48
;
; (4) Title start col:
;
33
;
; (5) Title style:
;
 
;
;----------------------------------------------------------
;
; (6) Field length:
;
36
;
; (7) Field window width:
;
21
;
; (8) Field contents:
;
Irish Red Cheddar
;
; (9) Field start row:
;
48
;
; (10) Field start col:
;
50
;
;
; (11) Field style:
;
 
;
;----------------------------------------------------------------------------
;
; This is where a stretch of text is to be placed in the form file:
;
; Heading:
Test of stretch of text with Lexa Form
;
; Text contents
;

Dear applicant,

If you really imagine that the above data sheet is to be taken seriously
by any prospective employer then you are mistaken. From the point of view
of our company I may state that anyone whose favourite cheese is Irish Red
Cheddar cannot be regarded as reliable and industrious. It is well-known
(i.e. scientists have shown beyond doubt) that the consumption of vast
quantities of Irish Red Cheddar is a major contributary factor in the dis-
integration of personality, in fact it ends in schizophrenia.













; Note: Omega above marks the end of the stretch of text
;
;============================================================================;
; This is a list of fields which are to be put in a delimited text file
; Numbering starts at first filled field, if (as above) there is an empty
; field to begin with then this is skipped in the numbering
;
; (no fields listed in this case, see form file STUDENT.FRM)
;
; End of File
