;
; General remarks on the structure of a form file for Lexa Form
;---------------------------------------------------------------
;
; Note: Any line which begins with a semi-colon is interpreted as a comment
; by Lexa Form and skipped. Be careful not to have any empty lines in a form
; file (unless explicitly advised to do so) as this leads to confusion. Any
; given line is either (i) a comment or (ii) an item of information for the
; current form.
;
; A form file can be edited with Lexa Text (or any text editor). Form files
; are pure ASCII texts.
;
; It is not obligatory to have both a Title and a Field together. If you
; wish to have just a Title, declare the Field length to be 0 and vice
; versa to suppress a Title.
;
; In order for a form to be printed successfully, each field must have a
; row coordinate which is greater than the previous one. Equally column
; coordinates must be in ascending numerical order. The reason for this is
; that one cannot assume that printers can move backwards during the printing
; process. If a field row coordinate is smaller than its predecessor then
; Lexa Form takes the latter value and adds 1 to it (i.e. prints the current
; field on the next line). Columns with smaller values than a previous one
; are simply incremented by 1 in a similar fashion.
;
; Remember that the row and column positions which you specify for a given
; field refer to the page coordinates. You may scroll vertically in any
; form which is longer than a screenful. Fields do not have to be on con-
; secutive lines. A title does not have to be on the same line as the field
; to which it belongs (it may be above or below it). You may scroll horiz-
; ontally in any field input line by specifying a Field Window Width which
; is smaller than the Field Length.
;
; If a title or a field exceeds the legal maximum then it is truncated to
; this. Note the following limits:
;
;	Maximum length of title:  64
;	Maximum length of field:  128
;
; 	Maximum length of text title:  64
; 	Maximum length of text line:   160
; 	Maximum number of text lines:  24
;
;	Maximum number of fields per form: 80
;
; Note that a form is not restricted to a single page. If the number of 
; fields, any additional files to be printed on the form and a possible
; header or footer result in a length greater than one page then the form
; will be continued on the next and so on until all the data of which the
; form consists has been printed. Equally there is no restriction on the
; size of a printed page. Normal forms will fit on A4 size paper, A3 can
; be used for forms with wides lines and many rows.
;
; The style to be used for both titles and field contents depends on the
; commands which are to be found in Lexa Text, that is the style numbers
; are place-holders which depend for their realization on the printer driver
; which you choose when you load the output text generated by Lexa Form 
; with Lexa Text (via F5) to print it. Entering 0 for a style leads to this
; parameter being ignored on output of the form.
; 
; Note: To reduce the size of a form file you may remove all the comments
; as these are of no relevance to the acceptance of the file by Lexa Form
; (compare MASTER.FRM and NO_COMM.FRM). This can be done by simply saving
; the file with comments from the form editing level when returning to
; the desktop.
;
; When developing a prototype of a form you should first of all design a
; master form with all the comments necessary for you to recognize its
; structure easily (at some later stage). You can take the present file
; as a starting point for convenience sake. Once the form has reached its
; final shape you can remove the comments (see preceding paragraph) and
; duplicate as necessary for each new set of data.
;
; Note: To print the current date as a form field enter [date] as the 
; field contents. Specify [time] to have the current time printed. The
; square bracketing must be included.
;
; If you specify a file name in  brackets then Lexa Form will check to
; see if ASCII 23 () or 18 () occur in this files and replace these by
; the current date and time respectively (same procedure as with Report DB).
;
;----------------------------------------------------------------------------;
; Item 1:  Is there a stretch of text to be included on form?
;
1
;----------------------------------------------------------------------------;
; Item 2:  Position of text (1 ? Bottom of form, 0 ? Top of form)
;
1
;----------------------------------------------------------------------------;
; Item 3:  Field total for entire form (max.: 80)
;
11
;----------------------------------------------------------------------------;
; Item 4: Required national date format (used for date strings in form!)
;
2
;----------------------------------------------------------------------------;
; Item 5: Use 50-line VGA display?
;
0
;----------------------------------------------------------------------------;
; Item 6: Name of file with text lines (code block via F2)
;
SNIPPET.TXT
;----------------------------------------------------------------------------;
; Item 7: Name of delimited text file for import into database
;
STUD_DEL.TXT
;----------------------------------------------------------------------------;
; Item 8: Name of user editor
;
LTEXT
;
;============================================================================;
; FIELD NO. 1
;
; 	(1) Title length:
12
; 	(2) Title name:
;
letterhe.ad
;
; 	(3) Title start row:
1
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
0
; 	(7) Field window width
0
; 	(8) Field contents:

; 	(9) Field start row:
0
; 	(10) Field start col:
0
; 	(11) Field style:
;============================================================================;
; FIELD NO. 2
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Seminar
; 	(3) Title start row:
2
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:
;
Mittelenglische Einfhrung
;
; 	(9) Field start row:
2
; 	(10) Field start col:
24
; 	(11) Field style:
?
;============================================================================;
; FIELD NO. 3
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Student
;
; 	(3) Title start row:
5
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:
MLLER, Max
; 	(9) Field start row:
5
; 	(10) Field start col:
24
; 	(11) Field style:
4
;=============================================================================;
; FIELD NO. 4
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Referat
; 	(3) Title start row:
7
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:
;
Die Ortsnamen im Sden Englands
;
; 	(9) Field start row:
7
; 	(10) Field start col:
24
; 	(11) Field style:
3
;============================================================================;
; FIELD NO. 5
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Structure of essay
;
; 	(3) Title start row:
12
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:

; 	(9) Field start row:
12
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; FIELD NO. 6
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Table of contents
;
; 	(3) Title start row:
14
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:

; 	(9) Field start row:
14
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; FIELD NO. 7
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Page layout
;
; 	(3) Title start row:
16
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:

; 	(9) Field start row:
16
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; FIELD NO. 8
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Bibliography
;
; 	(3) Title start row:
18
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:

; 	(9) Field start row:
18
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; FIELD NO. 9
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Quotations
;
; 	(3) Title start row:
20
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:

; 	(9) Field start row:
20
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; FIELD NO. 10
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Language style
;
; 	(3) Title start row:
22
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
40
; 	(7) Field window width
30
; 	(8) Field contents:

; 	(9) Field start row:
22
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; FIELD NO. 11
;
; 	(1) Title length:
20
; 	(2) Title name:
;
Mark
;
; 	(3) Title start row:
24
; 	(4) Title start col:
1
; 	(5) Title style:
;----------------------------------------------------------------------------;
; 	(6) Field length:
24
; 	(7) Field window width
24
; 	(8) Field contents:

; 	(9) Field start row:
24
; 	(10) Field start col:
24
; 	(11) Field style:
;============================================================================;
; This is where a stretch of text is to be placed in the form file:
;
; Heading:

;
; Text contents (max.: 22 lines)
;


Further comments

as d f asf as fas df asf as fdas fd safd safdas fd asfd asfdasfd asfdasfdadas
asfdas fdasfda sfd as fasfasfdasfdasfd as f asfd asf asfasf  asfdasfd  asfd asf
asfd asfd as fd asf safdasfd asfdasfd asfdsfd safdasfd  asdf sd fas fdasfd
asfd asfd asfd  asfd  asfd asfd asfdas fd asfd as fqwkl 90 9p82.bn .kb  dfg
aslj n 832  vmnybkj.vh uiash iuciuns auc lweuvuzkj nm. pz b78 quioxn qiu sdf
asdf  asdf iwrueiw iwqrheqnmbnmbxnmbvm,yxv ,mnyx.



(Raymond Hickey)









; Note: Omega above marks the end of the stretch of text
;
;============================================================================;
; This is a list of fields which are to be put in a delimited text file
; Numbering starts at first filled field, if (as above) there is an empty
; field to begin with then this is skipped in the numbering
;
; Seminar
; Student
; Referat
; Mark
1
;
; End of File
